/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.stemmer.NullStemmer;

public class Stemmer
extends AbstractTransformer {
    private static final long serialVersionUID = -4128320094517359349L;
    protected adams.flow.transformer.stemmer.Stemmer m_Stemmer;

    public String globalInfo() {
        return "Applies the stemmer to the incoming word/words.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stemmer", "stemmer", (Object)new NullStemmer());
    }

    public void setStemmer(adams.flow.transformer.stemmer.Stemmer value) {
        this.m_Stemmer = value;
        this.reset();
    }

    public adams.flow.transformer.stemmer.Stemmer getStemmer() {
        return this.m_Stemmer;
    }

    public String stemmerTipText() {
        return "The stemmer to apply.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"tokenizer", (Object)this.m_Stemmer, (String)"tokenizer: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class, String[].class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_InputToken.getPayload() instanceof String) {
            String singleOut = this.m_Stemmer.stem((String)this.m_InputToken.getPayload());
            this.m_OutputToken = new Token((Object)singleOut);
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            String[] multiIn = (String[])this.m_InputToken.getPayload();
            String[] multiOut = new String[multiIn.length];
            for (int i = 0; i < multiIn.length; ++i) {
                multiOut[i] = this.m_Stemmer.stem(multiIn[i]);
            }
            this.m_OutputToken = new Token((Object)multiOut);
        } else {
            result = "Unhandled input: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
        }
        return result;
    }
}

