/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CoNLLHelper {
    public static final String[] HEADERS = new String[]{"ID", "FORM", "LEMMA", "CPOSTAG", "POSTAG", "FEATS", "HEAD", "DEPREL", "PHEAD", "PDEPREL"};

    public static SpreadSheet parse(String content) {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setMissingValue(new BaseRegExp(""));
        reader.setSeparator("\\t");
        reader.setNoHeader(true);
        reader.setCustomColumnHeaders(Utils.flatten((Object[])HEADERS, (String)","));
        StringReader sreader = new StringReader(content);
        SpreadSheet result = reader.read((Reader)sreader);
        return result;
    }

    public static List<String> group(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).isEmpty()) {
                if (content.length() <= 0) continue;
                result.add(content.toString());
                content = new StringBuilder();
                continue;
            }
            if (content.length() > 0) {
                content.append("\n");
            }
            content.append(lines.get(i));
        }
        if (content.length() > 0) {
            result.add(content.toString());
        }
        return result;
    }
}

