/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;

public class StanfordGrammaticalStructure
extends AbstractTransformer {
    private static final long serialVersionUID = -563084917234302128L;
    protected TreebankLanguagePack m_LanguagePack;
    protected GrammaticalStructureFactory m_Factory;

    public String globalInfo() {
        return "Turns a Stanford parse tree into a grammatical structure.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("language-pack", "languagePack", (Object)new PennTreebankLanguagePack());
    }

    public void setLanguagePack(TreebankLanguagePack value) {
        this.m_LanguagePack = value;
        this.reset();
    }

    public TreebankLanguagePack getLanguagePack() {
        return this.m_LanguagePack;
    }

    public String languagePackTipText() {
        return "The language pack to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"languagePack", this.m_LanguagePack.getClass());
    }

    public Class[] accepts() {
        return new Class[]{Tree.class};
    }

    public Class[] generates() {
        return new Class[]{GrammaticalStructure.class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Factory == null) {
            this.m_Factory = this.m_LanguagePack.grammaticalStructureFactory();
        }
        GrammaticalStructure structure = this.m_Factory.newGrammaticalStructure((Tree)this.m_InputToken.getPayload());
        this.m_OutputToken = new Token((Object)structure);
        return result;
    }
}

