/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.tokenizer.AbstractTokenizer;
import adams.flow.transformer.tokenizer.StanfordPTBTokenizer;
import java.util.List;

public class Tokenize
extends AbstractArrayProvider {
    private static final long serialVersionUID = -4128320094517359349L;
    protected AbstractTokenizer m_Tokenizer;

    public String globalInfo() {
        return "Splits document strings into sentences using the specified document to sentences tokenizer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tokenizer", "tokenizer", (Object)new StanfordPTBTokenizer());
    }

    public String outputArrayTipText() {
        return "Whether to output the sentences as array or one-by-one.";
    }

    public void setTokenizer(AbstractTokenizer value) {
        this.m_Tokenizer = value;
        this.reset();
    }

    public AbstractTokenizer getTokenizer() {
        return this.m_Tokenizer;
    }

    public String tokenizerTipText() {
        return "The tokenizer to use for generating words from strings.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"tokenizer", (Object)((Object)this.m_Tokenizer), (String)"tokenizer: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    protected Class getItemClass() {
        return String.class;
    }

    protected String doExecute() {
        String result = null;
        try {
            List<String> words = this.m_Tokenizer.tokenize((String)this.m_InputToken.getPayload());
            this.m_Queue.addAll(words);
        }
        catch (Exception e) {
            result = this.handleException("Failed to tokenize string: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

