/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import com.kennycason.kumo.WordFrequency;

public class WordFrequenciesToSpreadShet
extends AbstractConversion {
    private static final long serialVersionUID = -5177248020254339908L;
    public static final String COL_WORD = "Word";
    public static final String COL_FREQUENCY = "Frequency";

    public String globalInfo() {
        return "Turns word frequencies into a spreadsheet with two columns: Word, Frequency";
    }

    public Class accepts() {
        return WordFrequency[].class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        WordFrequency[] freqs = (WordFrequency[])this.m_Input;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("W").setContentAsString(COL_WORD);
        row.addCell("F").setContentAsString(COL_FREQUENCY);
        for (WordFrequency freq : freqs) {
            row = result.addRow();
            row.addCell("W").setContentAsString(freq.getWord());
            row.addCell("F").setContent(Integer.valueOf(freq.getFrequency()));
        }
        return result;
    }
}

