/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.splitter.AbstractDocumentToSentences;
import adams.flow.transformer.splitter.StanfordPTBTokenizer;
import java.util.List;

public class DocumentToSentences
extends AbstractArrayProvider {
    private static final long serialVersionUID = -4128320094517359349L;
    protected AbstractDocumentToSentences m_Splitter;

    public String globalInfo() {
        return "Splits document strings into sentences using the specified document to sentences splitter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("splitter", "splitter", (Object)new StanfordPTBTokenizer());
    }

    public String outputArrayTipText() {
        return "Whether to output the sentences as array or one-by-one.";
    }

    public void setSplitter(AbstractDocumentToSentences value) {
        this.m_Splitter = value;
        this.reset();
    }

    public AbstractDocumentToSentences getSplitter() {
        return this.m_Splitter;
    }

    public String splitterTipText() {
        return "The splitter to use for generating sentence strings from document strings.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"splitter", (Object)((Object)this.m_Splitter), (String)"splitter: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    protected Class getItemClass() {
        return String.class;
    }

    protected String doExecute() {
        String result = null;
        try {
            List<String> sentences = this.m_Splitter.split((String)this.m_InputToken.getPayload());
            this.m_Queue.addAll(sentences);
        }
        catch (Exception e) {
            result = this.handleException("Failed to split sentence: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

