/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wordcloud;

import adams.core.MessageCollection;
import adams.core.base.BaseColor;
import adams.flow.transformer.wordcloud.AbstractColorPalette;
import com.github.fracpete.javautils.Enumerate;
import com.github.fracpete.javautils.enumerate.Enumerated;
import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Color;

public class ColorListPalette
extends AbstractColorPalette {
    private static final long serialVersionUID = -6953764652690047084L;
    protected BaseColor[] m_Colors;

    public String globalInfo() {
        return "Generates a color palette using the specified colors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "colors", (Object)new BaseColor[0]);
    }

    public void setColors(BaseColor[] value) {
        this.m_Colors = value;
        this.reset();
    }

    public BaseColor[] getColors() {
        return this.m_Colors;
    }

    public String colorsTipText() {
        return "The colors to create the palette from.";
    }

    @Override
    public ColorPalette generate(MessageCollection errors) {
        if (this.m_Colors.length == 0) {
            errors.add("No colors defined!");
            return null;
        }
        Color[] colors = new Color[this.m_Colors.length];
        for (Enumerated color : Enumerate.enumerate((Object[])this.m_Colors)) {
            colors[color.index] = ((BaseColor)color.value).toColorValue();
        }
        return new ColorPalette(colors);
    }
}

