/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wordcloud;

import adams.core.MessageCollection;
import adams.core.io.PlaceholderFile;
import adams.flow.transformer.wordcloud.AbstractBackground;
import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.bg.PixelBoundryBackground;

public class PixelBoundaryBackground
extends AbstractBackground {
    private static final long serialVersionUID = 2848272343570036328L;
    protected PlaceholderFile m_Background;

    public String globalInfo() {
        return "Generates a background mode based on the transparent pixel-boundaries of the specified image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background", "background", (Object)new PlaceholderFile());
    }

    public void setBackground(PlaceholderFile value) {
        this.m_Background = value;
        this.reset();
    }

    public PlaceholderFile getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background image to use.";
    }

    @Override
    public Background generate(MessageCollection errors) {
        if (!this.m_Background.exists()) {
            errors.add("Background image does not exist: " + this.m_Background);
            return null;
        }
        if (this.m_Background.isDirectory()) {
            errors.add("Background image points to a directory: " + this.m_Background);
            return null;
        }
        try {
            return new PixelBoundryBackground(this.m_Background.getAbsoluteFile());
        }
        catch (Exception e) {
            errors.add("Failed to construct the pixel boundary background!", (Throwable)e);
            return null;
        }
    }
}

