/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.nlp;

import adams.gui.core.BaseTree;
import adams.gui.visualization.nlp.StanfordNode;
import adams.gui.visualization.nlp.StanfordRenderer;
import edu.stanford.nlp.trees.Tree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class StanfordTree
extends BaseTree {
    private static final long serialVersionUID = -3618290386432060103L;
    protected Tree m_Tree;

    protected void initialize() {
        super.initialize();
        this.m_Tree = null;
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new StanfordRenderer());
        this.buildTree();
    }

    protected StanfordNode buildTree(StanfordNode parentNode, Tree parentTree) {
        if (parentNode == null) {
            parentNode = new StanfordNode("root", parentTree);
            this.buildTree(parentNode, parentTree);
        } else {
            for (int i = 0; i < parentTree.children().length; ++i) {
                Tree childTree = parentTree.children()[i];
                StanfordNode childNode = new StanfordNode(childTree.label().value(), childTree);
                parentNode.add((MutableTreeNode)((Object)childNode));
                this.buildTree(childNode, childTree);
            }
        }
        StanfordNode result = parentNode;
        return result;
    }

    protected void buildTree() {
        StanfordNode root = this.m_Tree == null ? new StanfordNode("empty", null) : this.buildTree(null, this.m_Tree);
        this.setModel(new DefaultTreeModel((TreeNode)((Object)root)));
        this.expand((DefaultMutableTreeNode)((Object)root));
    }

    public void setTree(Tree value) {
        this.m_Tree = value;
        this.buildTree();
    }

    public Tree getTree() {
        return this.m_Tree;
    }
}

