/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import com.kennycason.kumo.WordFrequency;
import java.util.ArrayList;

public class SpreadSheetToWordFrequencies
extends AbstractConversion {
    private static final long serialVersionUID = -5177248020254339908L;
    protected SpreadSheetColumnIndex m_ColumnWord;
    protected SpreadSheetColumnIndex m_ColumnFrequency;

    public String globalInfo() {
        return "Turns a spreadsheet with two columns for words and frequencies into an array of word frequency objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-word", "columnWord", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("column-frequency", "columnFrequency", (Object)new SpreadSheetColumnIndex("2"));
    }

    public void setColumnWord(SpreadSheetColumnIndex value) {
        this.m_ColumnWord = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnWord() {
        return this.m_ColumnWord;
    }

    public String columnWordTipText() {
        return "The column containing the words.";
    }

    public void setColumnFrequency(SpreadSheetColumnIndex value) {
        this.m_ColumnFrequency = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnFrequency() {
        return this.m_ColumnFrequency;
    }

    public String columnFrequencyTipText() {
        return "The column containing the frequencies.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return WordFrequency[].class;
    }

    protected Object doConvert() throws Exception {
        ArrayList<WordFrequency> result = new ArrayList<WordFrequency>();
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_ColumnWord.setData((Object)sheet);
        int colWord = this.m_ColumnWord.getIntIndex();
        if (colWord == -1) {
            throw new IllegalStateException("Failed to locate word column: " + this.m_ColumnWord.getIndex());
        }
        this.m_ColumnFrequency.setData((Object)sheet);
        int colFreq = this.m_ColumnFrequency.getIntIndex();
        if (colFreq == -1) {
            throw new IllegalStateException("Failed to locate frequency column: " + this.m_ColumnFrequency.getIndex());
        }
        for (Row row : sheet.rows()) {
            if (!row.hasCell(colWord) || row.getCell(colWord).isMissing() || !row.hasCell(colFreq) || row.getCell(colFreq).isMissing()) continue;
            result.add(new WordFrequency(row.getCell(colWord).getContent(), row.getCell(colFreq).toDouble().intValue()));
        }
        return result;
    }
}

