/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionToString;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.io.StringWriter;

public class StanfordParseTreeToXML
extends AbstractConversionToString {
    private static final long serialVersionUID = -309330039614297403L;
    protected boolean m_OutputScores;

    public String globalInfo() {
        return "Turns a Stanford parse tree into an XML string.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-scores", "outputScores", (Object)false);
    }

    public void setOutputScores(boolean value) {
        this.m_OutputScores = value;
        this.reset();
    }

    public boolean getOutputScores() {
        return this.m_OutputScores;
    }

    public String outputScoresTipText() {
        return "If enabled, the scores are output as well.";
    }

    public Class accepts() {
        return Tree.class;
    }

    protected Object doConvert() throws Exception {
        Tree tree = (Tree)this.m_Input;
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        tree.indentedXMLPrint(writer, this.m_OutputScores);
        writer.close();
        return swriter.toString();
    }
}

