/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.wordcloud.AbstractBackground;
import adams.flow.transformer.wordcloud.AbstractColorPalette;
import adams.flow.transformer.wordcloud.AbstractFontScalar;
import adams.flow.transformer.wordcloud.DefaultBackground;
import adams.flow.transformer.wordcloud.DefaultColorPalette;
import adams.flow.transformer.wordcloud.DefaultFontScalar;
import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.PolarBlendMode;
import com.kennycason.kumo.PolarWordCloud;
import com.kennycason.kumo.WordCloud;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.font.scale.FontScalar;
import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Dimension;
import java.util.Arrays;

public class GenerateWordCloud
extends AbstractTransformer {
    private static final long serialVersionUID = 3133377526712815523L;
    protected int m_Width;
    protected int m_Height;
    protected CollisionMode m_CollisionMode;
    protected PolarBlendMode m_PolarBlendMode;
    protected int m_Padding;
    protected AbstractColorPalette m_ColorPalette;
    protected AbstractFontScalar m_FontScalar;
    protected AbstractBackground m_Background;

    public String globalInfo() {
        return "Generates a word cloud from the incoming word frequencies.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)600, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)300, (Number)1, null);
        this.m_OptionManager.add("collision-mode", "collisionMode", (Object)CollisionMode.PIXEL_PERFECT);
        this.m_OptionManager.add("polar-blend-mode", "polarBlendMode", (Object)PolarBlendMode.BLUR);
        this.m_OptionManager.add("padding", "padding", (Object)2, (Number)0, null);
        this.m_OptionManager.add("color-palette", "colorPalette", (Object)new DefaultColorPalette());
        this.m_OptionManager.add("font-scalar", "fontScalar", (Object)new DefaultFontScalar());
        this.m_OptionManager.add("background", "background", (Object)new DefaultBackground());
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width for the image.";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height for the image.";
    }

    public void setCollisionMode(CollisionMode value) {
        this.m_CollisionMode = value;
        this.reset();
    }

    public CollisionMode getCollisionMode() {
        return this.m_CollisionMode;
    }

    public String collisionModeTipText() {
        return "The collision mode to use.";
    }

    public void setPolarBlendMode(PolarBlendMode value) {
        this.m_PolarBlendMode = value;
        this.reset();
    }

    public PolarBlendMode getPolarBlendMode() {
        return this.m_PolarBlendMode;
    }

    public String polarBlendModeTipText() {
        return "The polar blend mode to use.";
    }

    public void setPadding(int value) {
        if (this.getOptionManager().isValid("padding", (Number)value)) {
            this.m_Padding = value;
            this.reset();
        }
    }

    public int getPadding() {
        return this.m_Padding;
    }

    public String paddingTipText() {
        return "The padding to use.";
    }

    public void setColorPalette(AbstractColorPalette value) {
        this.m_ColorPalette = value;
        this.reset();
    }

    public AbstractColorPalette getColorPalette() {
        return this.m_ColorPalette;
    }

    public String colorPaletteTipText() {
        return "The color palette to use.";
    }

    public void setFontScalar(AbstractFontScalar value) {
        this.m_FontScalar = value;
        this.reset();
    }

    public AbstractFontScalar getFontScalar() {
        return this.m_FontScalar;
    }

    public String fontScalarTipText() {
        return "The font scalar to use.";
    }

    public void setBackground(AbstractBackground value) {
        this.m_Background = value;
        this.reset();
    }

    public AbstractBackground getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)"width: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", height: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"collisionMode", (Object)this.m_CollisionMode, (String)", collision-mode: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"polarBlendMode", (Object)this.m_PolarBlendMode, (String)", polar-blend-mode: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"padding", (Object)this.m_Padding, (String)", padding: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colorPalette", (Object)((Object)this.m_ColorPalette), (String)", palette: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"fontScalar", (Object)((Object)this.m_FontScalar), (String)", font: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"background", (Object)((Object)this.m_Background), (String)", background: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{WordFrequency[].class, WordFrequency[][].class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        WordFrequency[] freqs1 = null;
        WordFrequency[] freqs2 = null;
        if (this.m_InputToken.hasPayload(WordFrequency[].class)) {
            freqs1 = (WordFrequency[])this.m_InputToken.getPayload(WordFrequency[].class);
            freqs2 = null;
        } else {
            WordFrequency[][] matrix = (WordFrequency[][])this.m_InputToken.getPayload(WordFrequency[][].class);
            if (matrix.length == 2) {
                freqs1 = matrix[0];
                freqs2 = matrix[1];
            } else {
                result = "For a polar word cloud, exactly two word frequency arrays are required, found: " + matrix.length;
            }
        }
        if (result == null) {
            Object cloud = freqs2 == null ? new WordCloud(new Dimension(this.m_Width, this.m_Height), this.m_CollisionMode) : new PolarWordCloud(new Dimension(this.m_Width, this.m_Height), this.m_CollisionMode, this.m_PolarBlendMode);
            cloud.setPadding(this.m_Padding);
            MessageCollection errors = new MessageCollection();
            ColorPalette palette = this.m_ColorPalette.generate(errors);
            if (palette != null) {
                cloud.setColorPalette(palette);
            } else if (!errors.isEmpty()) {
                this.getLogger().warning("Failed to generate color palette with " + OptionUtils.getCommandLine((Object)((Object)this.m_ColorPalette)) + ":\n" + errors);
            }
            errors = new MessageCollection();
            FontScalar scalar = this.m_FontScalar.generate(errors);
            if (scalar != null) {
                cloud.setFontScalar(scalar);
            } else if (!errors.isEmpty()) {
                this.getLogger().warning("Failed to generate font scalar with " + OptionUtils.getCommandLine((Object)((Object)this.m_FontScalar)) + ":\n" + errors);
            }
            errors = new MessageCollection();
            Background bg = this.m_Background.generate(errors);
            if (bg != null) {
                cloud.setBackground(bg);
            } else if (!errors.isEmpty()) {
                this.getLogger().warning("Failed to generate background with " + OptionUtils.getCommandLine((Object)((Object)this.m_Background)) + ":\n" + errors);
            }
            if (freqs2 == null) {
                cloud.build(Arrays.asList(freqs1));
            } else {
                ((PolarWordCloud)cloud).build(Arrays.asList(freqs1), Arrays.asList(freqs2));
            }
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setContent((Object)cloud.getBufferedImage());
            this.m_OutputToken = new Token((Object)cont);
        }
        return result;
    }
}

