/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.Tree;
import java.util.Hashtable;

public class StanfordLexicalizedParser
extends AbstractTransformer {
    private static final long serialVersionUID = -563084917234302128L;
    public static final String BACKUP_PARSER = "parser";
    protected PlaceholderFile m_Model;
    protected BaseString[] m_AdditionalOptions;
    protected LexicalizedParser m_Parser;

    public String globalInfo() {
        return "Parses a string (= sentence) or string array (= tokenized sentence) using the Stanford LexicalizedParser.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model", "model", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("additional-option", "additionalOptions", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Parser = null;
    }

    public void setModel(PlaceholderFile value) {
        this.m_Model = value;
        this.reset();
    }

    public PlaceholderFile getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The model file to load and use.";
    }

    public void setAdditionalOptions(BaseString[] value) {
        this.m_AdditionalOptions = value;
        this.reset();
    }

    public BaseString[] getAdditionalOptions() {
        return this.m_AdditionalOptions;
    }

    public String additionalOptionsTipText() {
        return "The additional options for the parser.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"model", (Object)this.m_Model, (String)"model: ");
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_PARSER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Parser != null) {
            result.put(BACKUP_PARSER, this.m_Parser);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_PARSER)) {
            this.m_Parser = (LexicalizedParser)state.get(BACKUP_PARSER);
            state.remove(BACKUP_PARSER);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    public Class[] generates() {
        return new Class[]{Tree.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (!this.m_Model.exists()) {
                result = "Model file does not exist: " + this.m_Model;
            } else if (this.m_Model.isDirectory()) {
                result = "Model file points to a directory: " + this.m_Model;
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Parser == null) {
            String[] options = new String[this.m_AdditionalOptions.length];
            for (int i = 0; i < this.m_AdditionalOptions.length; ++i) {
                options[i] = this.m_AdditionalOptions[i].getValue();
            }
            this.m_Parser = LexicalizedParser.loadModel((String)this.m_Model.getAbsolutePath(), (String[])options);
        }
        Tree tree = this.m_InputToken.getPayload() instanceof String ? this.m_Parser.apply(Sentence.toWordList((String[])((String)this.m_InputToken.getPayload()).split("\\s"))) : this.m_Parser.apply(Sentence.toWordList((String[])((String[])this.m_InputToken.getPayload())));
        this.m_OutputToken = new Token((Object)tree);
        return result;
    }
}

