/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.core.io.CoNLLHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.management.ProcessUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.AbstractArrayProvider;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class TweeboParser
extends AbstractArrayProvider {
    private static final long serialVersionUID = -7736014447541322982L;
    protected PlaceholderFile m_Script;
    protected transient CollectingProcessOutput m_ProcessOutput;

    public String globalInfo() {
        return "Parses the incoming tweet text with the TweeboParser and forwards the generated CoNLL data.\n\nFor more information see:\nhttps://sourceforge.net/projects/tweeboparser/\nhttp://ilk.uvt.nl/conll/#dataformat";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new PlaceholderFile("run.sh"));
    }

    public String outputArrayTipText() {
        return "If enabled, then the CoNLL spreadsheets are output in an array rather than one-by-one.";
    }

    public void setScript(PlaceholderFile value) {
        this.m_Script = value;
        this.reset();
    }

    public PlaceholderFile getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "The script for running the TweeboParser.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    protected Class getItemClass() {
        return SpreadSheet.class;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (!this.m_Script.exists()) {
                result = "Parser script does not exist: " + this.m_Script;
            } else if (this.m_Script.isDirectory()) {
                result = "Parser script points to a directory: " + this.m_Script;
            }
        }
        return result;
    }

    protected String doExecute() {
        this.m_Queue.clear();
        String[] tweets = this.m_InputToken.getPayload() instanceof String ? new String[]{(String)this.m_InputToken.getPayload()} : (String[])this.m_InputToken.getPayload();
        File tmpFile = TempUtils.createTempFile((String)"tweebo", (String)".txt");
        PlaceholderFile inFile = new PlaceholderFile(tmpFile.getAbsolutePath() + ".predict");
        String result = FileUtils.saveToFileMsg(Arrays.asList(tweets), (File)tmpFile, (String)"UTF-8");
        if (result == null) {
            try {
                this.m_ProcessOutput = ProcessUtils.execute((String[])new String[]{this.m_Script.getAbsolutePath(), tmpFile.getAbsolutePath()}, (PlaceholderDirectory)new PlaceholderDirectory(this.m_Script.getParentFile()));
                if (!this.m_ProcessOutput.hasSucceeded()) {
                    result = "Failed to execute TweeboParser: " + Utils.flatten((Object[])this.m_ProcessOutput.getCommand(), (String)" ") + "\n" + this.m_ProcessOutput.getStdErr();
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute TweeboParser: " + this.m_Script, e);
            }
            this.m_ProcessOutput = null;
        }
        if (result == null && inFile.exists() && !inFile.isDirectory()) {
            List<String> lines = FileUtils.loadFromFile((File)inFile, (String)"UTF-8");
            lines = CoNLLHelper.group(lines);
            for (String content : lines) {
                this.m_Queue.add(CoNLLHelper.parse(content));
            }
        }
        if (tmpFile.exists()) {
            FileUtils.delete((File)tmpFile);
        }
        if (inFile.exists()) {
            FileUtils.delete((File)inFile);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_ProcessOutput != null) {
            this.m_ProcessOutput.destroy();
        }
        super.stopExecution();
    }
}

