/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.nlp.FrequencyAnalyzer;
import com.kennycason.kumo.nlp.normalize.Normalizer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class WordFrequencyAnalyzer
extends AbstractTransformer
implements EncodingSupporter {
    private static final long serialVersionUID = 8328022277704245871L;
    protected BaseCharset m_Encoding;
    protected Normalizer[] m_Normalizers;
    protected int m_MinWordLength;
    protected int m_MaxWordLength;
    protected int m_NumFrequencies;
    protected StorageName m_Stopwords;

    public String globalInfo() {
        return "Generates a word frequency analyzer from the incoming text.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("normalizer", "normalizers", (Object)new Normalizer[0]);
        this.m_OptionManager.add("min-word-length", "minWordLength", (Object)3, (Number)1, null);
        this.m_OptionManager.add("max-word-length", "maxWordLength", (Object)32, (Number)1, null);
        this.m_OptionManager.add("num-frequencies", "numFrequencies", (Object)50, (Number)1, null);
        this.m_OptionManager.add("stopwords", "stopwords", (Object)new StorageName());
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when writing to the file, use empty string for default.";
    }

    public void setNormalizers(Normalizer[] value) {
        this.m_Normalizers = value;
        this.reset();
    }

    public Normalizer[] getNormalizers() {
        return this.m_Normalizers;
    }

    public String normalizersTipText() {
        return "The normalizers to use.";
    }

    public void setMinWordLength(int value) {
        if (this.getOptionManager().isValid("minWordLength", (Number)value)) {
            this.m_MinWordLength = value;
            this.reset();
        }
    }

    public int getMinWordLength() {
        return this.m_MinWordLength;
    }

    public String minWordLengthTipText() {
        return "The minimum length for words.";
    }

    public void setMaxWordLength(int value) {
        if (this.getOptionManager().isValid("maxWordLength", (Number)value)) {
            this.m_MaxWordLength = value;
            this.reset();
        }
    }

    public int getMaxWordLength() {
        return this.m_MaxWordLength;
    }

    public String maxWordLengthTipText() {
        return "The maximum length for words.";
    }

    public void setNumFrequencies(int value) {
        if (this.getOptionManager().isValid("numFrequencies", (Number)value)) {
            this.m_NumFrequencies = value;
            this.reset();
        }
    }

    public int getNumFrequencies() {
        return this.m_NumFrequencies;
    }

    public String numFrequenciesTipText() {
        return "The number of frequencies to return.";
    }

    public void setStopwords(StorageName value) {
        this.m_Stopwords = value;
        this.reset();
    }

    public StorageName getStopwords() {
        return this.m_Stopwords;
    }

    public String stopwordsTipText() {
        return "The storage item that holds the string array of stopwords to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"minWordLength", (Object)this.m_MinWordLength, (String)"min: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxWordLength", (Object)this.m_MaxWordLength, (String)", max: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numFrequencies", (Object)this.m_NumFrequencies, (String)", #: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"stopwords", (Object)(this.m_Stopwords.isEmpty() ? "-none-" : this.m_Stopwords.getValue()), (String)", stopwords: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{WordFrequency[].class};
    }

    protected String doExecute() {
        String result = null;
        String text = (String)this.m_InputToken.getPayload(String.class);
        ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(this.m_Encoding.charsetValue()));
        FrequencyAnalyzer analyzer = new FrequencyAnalyzer();
        analyzer.clearNormalizers();
        for (Normalizer normalizer : this.m_Normalizers) {
            analyzer.addNormalizer(normalizer);
        }
        analyzer.setCharacterEncoding(this.m_Encoding.getValue());
        analyzer.setMinWordLength(this.m_MinWordLength);
        analyzer.setMaxWordLength(this.m_MaxWordLength);
        analyzer.setWordFrequenciesToReturn(this.m_NumFrequencies);
        if (!this.m_Stopwords.isEmpty() && this.getStorageHandler().getStorage().has(this.m_Stopwords)) {
            try {
                String[] stopwords = (String[])this.getStorageHandler().getStorage().get(this.m_Stopwords);
                analyzer.setStopWords(Arrays.asList(stopwords));
            }
            catch (Exception e) {
                result = this.handleException("Failed to retrieved stopwords string array from storage item: " + this.m_Stopwords, e);
            }
        }
        try {
            List frequencies = analyzer.load((InputStream)stream);
            this.m_OutputToken = new Token((Object)frequencies.toArray(new WordFrequency[0]));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate word frequencies!", e);
        }
        return result;
    }
}

