/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wordcloud;

import adams.core.MessageCollection;
import adams.core.base.BaseColor;
import adams.flow.transformer.wordcloud.AbstractColorPalette;
import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Color;

public class LinearGradientColorPalette
extends AbstractColorPalette {
    private static final long serialVersionUID = -918453046276035417L;
    protected BaseColor m_First;
    protected BaseColor m_Second;
    protected BaseColor m_Third;
    protected int m_FirstSteps;
    protected int m_SecondSteps;

    public String globalInfo() {
        return "Generates a linear gradient between the two colors or three colors if the second steps is >0.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("first", "first", (Object)new BaseColor(Color.RED));
        this.m_OptionManager.add("second", "second", (Object)new BaseColor(Color.BLUE));
        this.m_OptionManager.add("third", "third", (Object)new BaseColor(Color.GREEN));
        this.m_OptionManager.add("first-steps", "firstSteps", (Object)30, (Number)1, null);
        this.m_OptionManager.add("second-steps", "secondSteps", (Object)0, (Number)0, null);
    }

    public void setFirst(BaseColor value) {
        this.m_First = value;
        this.reset();
    }

    public BaseColor getFirst() {
        return this.m_First;
    }

    public String firstTipText() {
        return "The first color.";
    }

    public void setSecond(BaseColor value) {
        this.m_Second = value;
        this.reset();
    }

    public BaseColor getSecond() {
        return this.m_Second;
    }

    public String secondTipText() {
        return "The second color.";
    }

    public void setThird(BaseColor value) {
        this.m_Third = value;
        this.reset();
    }

    public BaseColor getThird() {
        return this.m_Third;
    }

    public String thirdTipText() {
        return "The third color.";
    }

    public void setFirstSteps(int value) {
        if (this.getOptionManager().isValid("firstSteps", (Number)value)) {
            this.m_FirstSteps = value;
            this.reset();
        }
    }

    public int getFirstSteps() {
        return this.m_FirstSteps;
    }

    public String firstStepsTipText() {
        return "The number of steps to use between first and second color.";
    }

    public void setSecondSteps(int value) {
        if (this.getOptionManager().isValid("secondSteps", (Number)value)) {
            this.m_SecondSteps = value;
            this.reset();
        }
    }

    public int getSecondSteps() {
        return this.m_SecondSteps;
    }

    public String secondStepsTipText() {
        return "The number of steps to use between second and third color, ignored if 0.";
    }

    @Override
    public ColorPalette generate(MessageCollection errors) {
        if (this.m_SecondSteps > 0) {
            return new com.kennycason.kumo.palette.LinearGradientColorPalette(this.m_First.toColorValue(), this.m_Second.toColorValue(), this.m_Third.toColorValue(), this.m_FirstSteps, this.m_SecondSteps);
        }
        return new com.kennycason.kumo.palette.LinearGradientColorPalette(this.m_First.toColorValue(), this.m_Second.toColorValue(), this.m_FirstSteps);
    }
}

