/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers.cleaners;

import adams.core.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.cleaners.AbstractTokenCleaner;

public class RemoveEmoticons
extends AbstractTokenCleaner {
    private static final long serialVersionUID = -1815343837519097597L;
    public static final String MODEL = "model";
    public static final String INVERT = "invert";
    protected File m_Model = this.getDefaultModel();
    protected boolean m_Invert = false;
    protected transient Set<String> m_Vocabulary;

    public String globalInfo() {
        return "Removes emoticons, based on a provided lists of emoticon strings.\nMatching sense can be inverted, i.e., only emoticons get returned.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.modelTipText(), (String)("" + this.getDefaultModel()), (String)MODEL);
        WekaOptionUtils.addOption(result, (String)this.invertTipText(), (String)"no", (String)INVERT);
        WekaOptionUtils.add(result, (Enumeration)super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setModel(WekaOptionUtils.parse((String[])options, (String)MODEL, (File)this.getDefaultModel()));
        this.setInvert(Utils.getFlag((String)INVERT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList result = new ArrayList();
        WekaOptionUtils.add(result, (String)MODEL, (File)this.getModel());
        WekaOptionUtils.add(result, (String)INVERT, (boolean)this.getInvert());
        WekaOptionUtils.add(result, (String[])super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected void reset() {
        super.reset();
        this.m_Vocabulary = null;
    }

    protected File getDefaultModel() {
        return new File(".");
    }

    public void setModel(File value) {
        this.m_Model = value;
        this.reset();
    }

    public File getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The model file to load and use; no header; one emoticon per line; ignores anything after tab.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, the emoticons are the only tokens not removed.";
    }

    public String clean(String token) {
        if (this.m_Vocabulary == null) {
            if (!this.m_Model.exists()) {
                throw new IllegalStateException("Emoticon model file does not exist: " + this.m_Model);
            }
            if (this.m_Model.isDirectory()) {
                throw new IllegalStateException("Emoticon model file points to a directory: " + this.m_Model);
            }
            this.m_Vocabulary = new HashSet<String>();
            List lines = FileUtils.loadFromFile((File)this.m_Model);
            for (String line : lines) {
                this.m_Vocabulary.add(line.replaceAll("\t.*", ""));
            }
        }
        if (this.m_Invert && !this.m_Vocabulary.contains(token)) {
            return null;
        }
        if (!this.m_Invert && this.m_Vocabulary.contains(token)) {
            return null;
        }
        return token;
    }
}

