/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers.cleaners;

import adams.core.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.cleaners.AbstractTokenCleaner;

public class WordCluster
extends AbstractTokenCleaner {
    private static final long serialVersionUID = 4367295660326278568L;
    public static final String MODEL = "model";
    public static final String UNKNOWN_WORD = "???";
    protected File m_Model = this.getDefaultModel();
    protected transient Map<String, String> m_Clusters;

    public String globalInfo() {
        return "Replaces words with clusters.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.modelTipText(), (String)("" + this.getDefaultModel()), (String)MODEL);
        WekaOptionUtils.add(result, (Enumeration)super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setModel(WekaOptionUtils.parse((String[])options, (String)MODEL, (File)this.getDefaultModel()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList result = new ArrayList();
        WekaOptionUtils.add(result, (String)MODEL, (File)this.getModel());
        WekaOptionUtils.add(result, (String[])super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected void reset() {
        super.reset();
        this.m_Clusters = null;
    }

    protected File getDefaultModel() {
        return new File(".");
    }

    public void setModel(File value) {
        this.m_Model = value;
        this.reset();
    }

    public File getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The tab-separated model file to load and use; no header; 1st column is cluster, 2nd column is word.";
    }

    public String clean(String token) {
        if (this.m_Clusters == null) {
            if (!this.m_Model.exists()) {
                throw new IllegalStateException("Cluster model file does not exist: " + this.m_Model);
            }
            if (this.m_Model.isDirectory()) {
                throw new IllegalStateException("Cluster model file points to a directory: " + this.m_Model);
            }
            this.m_Clusters = new HashMap<String, String>();
            List lines = FileUtils.loadFromFile((File)this.m_Model);
            for (String line : lines) {
                String[] parts = line.split("\t");
                if (parts.length < 2) continue;
                this.m_Clusters.put(parts[1], parts[0]);
            }
        }
        if (this.m_Clusters.containsKey(token)) {
            return this.m_Clusters.get(token);
        }
        return UNKNOWN_WORD;
    }
}

