/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.io.FileUtils;
import cmu.arktweetnlp.Twokenize;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AbstractTweetContentFilter;

public class TwitterEmoticonScore
extends AbstractTweetContentFilter {
    private static final long serialVersionUID = -6908047935900687249L;
    public static final String MODEL = "model";
    public static final String ATT_SCORE_OVERALL = "HappinessScore-Overall";
    public static final String ATT_SCORE_PREFIX = "HappinessScore-";
    public static final String ATT_LABEL = "HappinessLabel";
    public static final String LABEL_HAPPY = "happy";
    public static final String LABEL_NEUTRAL = "neutral";
    public static final String LABEL_SAD = "sad";
    protected File m_Model = this.getDefaultModel();
    protected transient Map<String, Double> m_Scores;

    public String globalInfo() {
        return "Computes the happiness score of tweets using the supplied emoticon lexicon model.\nIt adds numeric attribute for the overall score, cumulative scores for happy and sad, count of neutral ones, and a nominal attribute (happy, neutral, sad).\nThe emoticon lexicon is required to have two columns: emoticon string and\nassociated score. The lexicon file itself is tab-separated and has no header.\n";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.modelTipText(), (String)("" + this.getDefaultModel()), (String)MODEL);
        WekaOptionUtils.add(result, (Enumeration)super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setModel(WekaOptionUtils.parse((String[])options, (String)MODEL, (File)this.getDefaultModel()));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList result = new ArrayList();
        WekaOptionUtils.add(result, (String)MODEL, (File)this.getModel());
        WekaOptionUtils.add(result, (String[])super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected void reset() {
        super.reset();
        this.m_Scores = null;
    }

    protected File getDefaultModel() {
        return new File(".");
    }

    public void setModel(File value) {
        this.m_Model = value;
        this.reset();
    }

    public File getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The model file to load and use.";
    }

    @Override
    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.checkInputFormat(inputFormat);
        if (this.m_Scores == null) {
            if (!this.m_Model.exists()) {
                throw new WekaException("Model file does not exist: " + this.m_Model);
            }
            if (this.m_Model.isDirectory()) {
                throw new WekaException("Model file points to a directory: " + this.m_Model);
            }
            this.m_Scores = new HashMap<String, Double>();
            List lines = FileUtils.loadFromFile((File)this.m_Model);
            for (String line : lines) {
                String[] parts = line.split("\t");
                if (parts.length < 2) continue;
                try {
                    double score = Double.parseDouble(parts[1]);
                    this.m_Scores.put(parts[0], score);
                }
                catch (Exception e) {
                    System.err.println("Failed to parse: " + line);
                }
            }
            if (this.getDebug()) {
                System.out.println("# emoticons: " + this.m_Scores.size());
            }
        }
        ArrayList<Attribute> att = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            att.add((Attribute)inputFormat.attribute(i).copy());
        }
        att.add(new Attribute(ATT_SCORE_OVERALL));
        att.add(new Attribute("HappinessScore-happy"));
        att.add(new Attribute("HappinessScore-neutral"));
        att.add(new Attribute("HappinessScore-sad"));
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(LABEL_HAPPY);
        labels.add(LABEL_NEUTRAL);
        labels.add(LABEL_SAD);
        att.add(new Attribute(ATT_LABEL, labels));
        Instances result = new Instances("Happiness Score", att, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.getOutputFormat(), instances.numInstances());
        Attribute attrCont = instances.attribute(this.m_AttributeName);
        for (int inst = 0; inst < instances.numInstances(); ++inst) {
            Instance instance = instances.instance(inst);
            double[] values = new double[result.numAttributes()];
            for (int att = 0; att < instance.numAttributes(); ++att) {
                values[att] = instance.isMissing(att) ? Utils.missingValue() : (instance.attribute(att).isString() ? (double)result.attribute(att).addStringValue(instance.stringValue(att)) : instance.value(att));
            }
            String content = instances.instance(inst).stringValue(attrCont);
            List tokens = Twokenize.tokenizeRawTweetText((String)content);
            double overall = 0.0;
            HashMap<String, Double> scores = new HashMap<String, Double>();
            scores.put(LABEL_HAPPY, 0.0);
            scores.put(LABEL_NEUTRAL, 0.0);
            scores.put(LABEL_SAD, 0.0);
            for (String token : tokens) {
                if (!this.m_Scores.containsKey(token)) continue;
                double score = this.m_Scores.get(token);
                overall += score;
                if (score < 0.0) {
                    scores.put(LABEL_SAD, (Double)scores.get(LABEL_SAD) + score);
                    continue;
                }
                if (score > 0.0) {
                    scores.put(LABEL_HAPPY, (Double)scores.get(LABEL_HAPPY) + score);
                    continue;
                }
                scores.put(LABEL_NEUTRAL, (Double)scores.get(LABEL_NEUTRAL) + 1.0);
            }
            values[result.attribute((String)ATT_SCORE_OVERALL).index()] = overall;
            values[result.attribute((String)"HappinessScore-happy").index()] = (Double)scores.get(LABEL_HAPPY);
            values[result.attribute((String)"HappinessScore-neutral").index()] = (Double)scores.get(LABEL_NEUTRAL);
            values[result.attribute((String)"HappinessScore-sad").index()] = (Double)scores.get(LABEL_SAD);
            String label = overall > 0.0 ? LABEL_HAPPY : (overall < 0.0 ? LABEL_SAD : LABEL_NEUTRAL);
            values[result.attribute((String)ATT_LABEL).index()] = result.attribute(ATT_LABEL).indexOfValue(label);
            instance = new DenseInstance(1.0, values);
            result.add(instance);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        TwitterEmoticonScore.runFilter((Filter)new TwitterEmoticonScore(), (String[])args);
    }
}

