/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ODFHelper;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ODFHelperTest
extends AdamsTestCase {
    public ODFHelperTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/core/data");
    }

    public void testCellPositions() {
        int row = 0;
        int col = 0;
        String pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"A1", (String)pos);
        row = 1;
        col = 2;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"C2", (String)pos);
        row = 1;
        col = 25;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"Z2", (String)pos);
        row = 1;
        col = 26;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AA2", (String)pos);
        row = 2;
        col = 51;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AZ3", (String)pos);
        row = 2;
        col = 52;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"BA3", (String)pos);
        row = 2;
        col = 701;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"ZZ3", (String)pos);
        row = 2;
        col = 702;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AAA3", (String)pos);
        row = 20;
        col = 900;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AHQ21", (String)pos);
        row = 23;
        col = 1000;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"ALM24", (String)pos);
        row = 23;
        col = 18279;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AAAB24", (String)pos);
        row = 23;
        col = 475255;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AAAAB24", (String)pos);
        row = 23;
        col = 12356631;
        pos = ODFHelper.getCellPosition((int)row, (int)col);
        ODFHelperTest.assertEquals((String)"position differs", (String)"AAAAAB24", (String)pos);
    }

    public void testCellLocations() {
        try {
            int row = 0;
            int col = 0;
            int[] loc = ODFHelper.getCellLocation((String)"A1");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 1;
            col = 2;
            loc = ODFHelper.getCellLocation((String)"C2");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 1;
            col = 25;
            loc = ODFHelper.getCellLocation((String)"Z2");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 1;
            col = 26;
            loc = ODFHelper.getCellLocation((String)"AA2");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 2;
            col = 51;
            loc = ODFHelper.getCellLocation((String)"AZ3");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 2;
            col = 52;
            loc = ODFHelper.getCellLocation((String)"BA3");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 2;
            col = 701;
            loc = ODFHelper.getCellLocation((String)"ZZ3");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 2;
            col = 702;
            loc = ODFHelper.getCellLocation((String)"AAA3");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 20;
            col = 900;
            loc = ODFHelper.getCellLocation((String)"AHQ21");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 23;
            col = 1000;
            loc = ODFHelper.getCellLocation((String)"ALM24");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 23;
            col = 18279;
            loc = ODFHelper.getCellLocation((String)"AAAB24");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 23;
            col = 475255;
            loc = ODFHelper.getCellLocation((String)"AAAAB24");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
            row = 23;
            col = 12356631;
            loc = ODFHelper.getCellLocation((String)"AAAAAB24");
            ODFHelperTest.assertEquals((String)"row differs", (int)row, (int)loc[0]);
            ODFHelperTest.assertEquals((String)"col differs", (int)col, (int)loc[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            ODFHelperTest.fail((String)e.toString());
        }
    }

    public static Test suite() {
        return new TestSuite(ODFHelperTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ODFHelperTest.runTest((Test)ODFHelperTest.suite());
    }
}

