/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.data.io.input.ODFSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriterWithFormulaSupport;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jopendocument.dom.spreadsheet.SheetTableModel;

public class ODFSpreadSheetWriter
extends AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport
implements SpreadSheetWriterWithFormulaSupport {
    private static final long serialVersionUID = -3549185519778801930L;
    public static String FILE_EXTENSION = ".ods";
    protected boolean m_OutputAsDisplayed;

    public String globalInfo() {
        return "Writes ODF (Open Document Format) spreadsheet files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-as-displayed", "outputAsDisplayed", (Object)false);
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new ODFSpreadSheetReader();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.STREAM;
    }

    public void setOutputAsDisplayed(boolean value) {
        this.m_OutputAsDisplayed = value;
        this.reset();
    }

    public boolean getOutputAsDisplayed() {
        return this.m_OutputAsDisplayed;
    }

    public String outputAsDisplayedTipText() {
        return "If enabled, cells are output as displayed, ie, results of formulas instead of the formulas.";
    }

    protected boolean doWrite(SpreadSheet[] content, OutputStream out) {
        boolean result = true;
        try {
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.createEmpty((TableModel)new DefaultTableModel());
            DateFormat dformat = DateUtils.getTimestampFormatter();
            int count = 0;
            HashSet<String> names = new HashSet<String>();
            for (SpreadSheet cont : content) {
                String name;
                int i;
                ++count;
                Object[] colNames = new String[cont.getColumnCount()];
                HeaderRow row = cont.getHeaderRow();
                for (i = 0; i < cont.getColumnCount(); ++i) {
                    colNames[i] = row.getCell(i) == null || row.getCell(i).isMissing() ? this.m_MissingValue : row.getCell(i).getContent().toString();
                }
                DefaultTableModel model = new DefaultTableModel(colNames, cont.getRowCount());
                for (int n = 0; n < cont.getRowCount(); ++n) {
                    row = cont.getRow(n);
                    for (i = 0; i < cont.getColumnCount(); ++i) {
                        Cell cell = row.getCell(i);
                        if (cell == null || cell.isMissing()) {
                            model.setValueAt(this.m_MissingValue, n, i);
                            continue;
                        }
                        if (cell.isFormula() && !this.m_OutputAsDisplayed) {
                            model.setValueAt(cell.getFormula(), n, i);
                            continue;
                        }
                        if (cell.isDate()) {
                            model.setValueAt(dformat.format(cell.toDate()), n, i);
                            continue;
                        }
                        if (cell.isTime()) {
                            model.setValueAt(dformat.format((Date)cell.toTime()), n, i);
                            continue;
                        }
                        if (cell.isDateTime()) {
                            model.setValueAt(dformat.format((Date)cell.toDateTime()), n, i);
                            continue;
                        }
                        model.setValueAt(cell.getContent().toString(), n, i);
                    }
                }
                org.jopendocument.dom.spreadsheet.SpreadSheet single = org.jopendocument.dom.spreadsheet.SpreadSheet.createEmpty((TableModel)model);
                SheetTableModel singleModel = single.getSheet(0).getTableModel(0, 0);
                if (cont.getName() != null) {
                    name = cont.getName().replace("'", "");
                    if (names.contains(name)) {
                        name = name + (count + 1);
                    }
                } else {
                    name = this.m_SheetPrefix + (count + 1);
                }
                names.add(name);
                if (count > 1) {
                    spreadsheet.addSheet(name);
                } else {
                    spreadsheet.getSheet(0).setName(name);
                }
                spreadsheet.getSheet(name).merge((TableModel)singleModel, 0, 0);
            }
            spreadsheet.getPackage().save(out);
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", e);
        }
        return result;
    }
}

