/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Range;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.data.io.input.AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.NoHeaderSpreadSheetReader;
import adams.data.io.input.WindowedSpreadSheetReader;
import adams.data.io.output.ODFSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.Sheet;

public class ODFSpreadSheetReader
extends AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport
implements NoHeaderSpreadSheetReader,
WindowedSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;
    protected Range m_TextColumns;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected int m_FirstRow;
    protected int m_NumRows;

    public String globalInfo() {
        return "Reads ODF (Open Document Format) spreadsheet files.\nIf a row contains only empty cells, this is interpreted as the end of the sheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text-columns", "textColumns", (Object)"");
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("first-row", "firstRow", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)-1, (Number)-1, null);
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new ODFSpreadSheetWriter();
    }

    protected void initialize() {
        super.initialize();
        this.m_TextColumns = new Range();
    }

    public void setTextColumns(String value) {
        this.m_TextColumns.setRange(value);
        this.reset();
    }

    public String getTextColumns() {
        return this.m_TextColumns.getRange();
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    public void setFirstRow(int value) {
        if (this.getOptionManager().isValid("firstRow", (Number)value)) {
            this.m_FirstRow = value;
            this.reset();
        }
    }

    public int getFirstRow() {
        return this.m_FirstRow;
    }

    public String firstRowTipText() {
        return "The index of the first row to retrieve (1-based).";
    }

    public void setNumRows(int value) {
        this.m_NumRows = value < 0 ? -1 : value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of data rows to retrieve; use -1 for unlimited.";
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected String numericToString(String s) {
        Double dbl = Utils.toDouble((String)s);
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        try {
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage(in));
            this.m_SheetRange.setMax(spreadsheet.getSheetCount());
            int[] indices = this.m_SheetRange.getIntIndices();
            int firstRow = this.m_FirstRow - 1;
            int dataRowStart = this.getNoHeader() ? firstRow : firstRow + 1;
            block10: for (int index : indices) {
                String cellStr;
                int i;
                List header;
                SpreadSheet spsheet = this.m_SpreadSheetType.newInstance();
                spsheet.setDataRowClass(this.m_DataRowType.getClass());
                result.add(spsheet);
                Sheet sheet = spreadsheet.getSheet(index);
                spsheet.setName(sheet.getName());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("sheet: " + (index + 1));
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("header row");
                }
                HeaderRow row = spsheet.getHeaderRow();
                if (this.getNoHeader()) {
                    header = SpreadSheetUtils.createHeader((int)sheet.getColumnCount(), (String)this.m_CustomColumnHeaders);
                    for (i = 0; i < header.size(); ++i) {
                        row.addCell("" + (i + 1)).setContent((String)header.get(i));
                    }
                } else if (!this.m_CustomColumnHeaders.trim().isEmpty()) {
                    header = SpreadSheetUtils.createHeader((int)sheet.getColumnCount(), (String)this.m_CustomColumnHeaders);
                    for (i = 0; i < header.size(); ++i) {
                        row.addCell("" + (i + 1)).setContent((String)header.get(i));
                    }
                } else {
                    for (i = 0; i < sheet.getColumnCount() && !this.m_Stopped && (cellStr = sheet.getCellAt(i, firstRow).getTextValue()).length() != 0; ++i) {
                        row.addCell("" + (i + 1)).setContent(cellStr);
                    }
                }
                this.m_TextColumns.setMax(spsheet.getColumnCount());
                int lastRow = this.m_NumRows < 1 ? sheet.getRowCount() - 1 : Math.min(firstRow + this.m_NumRows, sheet.getRowCount() - 1);
                for (int n = dataRowStart; n <= lastRow && !this.m_Stopped; ++n) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("data row: " + (i + 1));
                    }
                    Object[] data = new Object[spsheet.getColumnCount()];
                    Cell.ContentType[] cellTypes = new Cell.ContentType[spsheet.getColumnCount()];
                    boolean empty = true;
                    for (i = 0; i < spsheet.getColumnCount(); ++i) {
                        ODValueType type = sheet.getCellAt(i, n).getValueType();
                        cellStr = sheet.getCellAt(i, n).getTextValue();
                        if (this.m_TextColumns.isInRange(i)) {
                            switch (type) {
                                case CURRENCY: 
                                case FLOAT: 
                                case PERCENTAGE: {
                                    data[i] = this.numericToString(cellStr);
                                    break;
                                }
                                default: {
                                    data[i] = cellStr;
                                }
                            }
                            cellTypes[i] = Cell.ContentType.STRING;
                            empty = false;
                        } else if (cellStr.length() > 0) {
                            switch (type) {
                                case DATE: {
                                    data[i] = spsheet.getDateTimeFormat().parse(cellStr);
                                    cellTypes[i] = Cell.ContentType.DATETIME;
                                    break;
                                }
                                case TIME: {
                                    data[i] = spsheet.getTimeFormat().parse(cellStr);
                                    cellTypes[i] = Cell.ContentType.TIME;
                                    break;
                                }
                                case CURRENCY: 
                                case FLOAT: 
                                case PERCENTAGE: {
                                    if (Utils.isLong((String)cellStr)) {
                                        data[i] = Long.parseLong(cellStr);
                                        cellTypes[i] = Cell.ContentType.LONG;
                                        break;
                                    }
                                    data[i] = Utils.toDouble((String)cellStr);
                                    cellTypes[i] = Cell.ContentType.DOUBLE;
                                }
                            }
                            if (data[i] == null) {
                                data[i] = cellStr;
                                cellTypes[i] = Cell.ContentType.STRING;
                            }
                            empty = false;
                        }
                        if (data[i] == null || !this.m_MissingValue.isMatch("" + data[i])) continue;
                        data[i] = null;
                    }
                    if (empty) continue block10;
                    row = spsheet.addRow("" + spsheet.getRowCount());
                    for (i = 0; i < data.length; ++i) {
                        if (data[i] == null) {
                            row.addCell("" + (i + 1)).setContent("?");
                            continue;
                        }
                        if (data[i] instanceof Double) {
                            row.addCell("" + (i + 1)).setContent((Double)data[i]);
                            continue;
                        }
                        if (data[i] instanceof Long) {
                            row.addCell("" + (i + 1)).setContent((Long)data[i]);
                            continue;
                        }
                        row.addCell("" + (i + 1)).setContentAsString((String)data[i]);
                    }
                }
            }
        }
        catch (Exception ioe) {
            this.getLogger().log(Level.SEVERE, "Failed to read range '" + this.m_SheetRange + "':", (Throwable)ioe);
            result = null;
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + LoggingHelper.throwableToString((Throwable)ioe);
        }
        return result;
    }
}

