/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Range;
import adams.core.io.FileUtils;
import adams.data.io.input.ODFSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.previewbrowser.AbstractSpreadSheetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import org.jopendocument.dom.ODPackage;

public class ODFSpreadSheetHandler
extends AbstractSpreadSheetHandler {
    private static final long serialVersionUID = -57718234789783854L;

    public String[] getExtensions() {
        return new String[]{"ods"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSheetCount(File file) {
        int result;
        BufferedInputStream input = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file.getAbsoluteFile());
            input = new BufferedInputStream(fis);
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage((InputStream)input));
            result = spreadsheet.getSheetCount();
        }
        catch (Exception e) {
            try {
                result = 0;
                this.getLogger().log(Level.SEVERE, "Failed to determine sheet count for '" + file + "':", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(input);
                FileUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)input);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)input);
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }

    protected SpreadSheet[] readAll(File file) {
        ODFSpreadSheetReader reader = new ODFSpreadSheetReader();
        reader.setSheetRange(new Range("first-last"));
        ArrayList result = reader.readRange(file);
        if (result == null) {
            result = new ArrayList();
        }
        return result.toArray(new SpreadSheet[result.size()]);
    }
}

