/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.features;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.opencv.OpenCVHelper;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.features.AbstractOpenCVFeatureGenerator;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public abstract class AbstractOpenCVFeatureGeneratorTestCase
extends AdamsTestCase {
    public AbstractOpenCVFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/opencv/features/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!OpenCVHelper.isAvailable()) {
            this.m_SkipTests.add(((Object)((Object)this)).getClass().getName());
        }
    }

    protected OpenCVImageContainer load(String filename) {
        OpenCVImageContainer result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        Mat img = opencv_imgcodecs.imread((String)new TmpFile(filename).getAbsolutePath());
        if (img != null) {
            result = new OpenCVImageContainer();
            result.setImage((Object)img);
            result.getReport().setStringValue("Filename", new PlaceholderFile(filename).getName());
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected Object[] process(OpenCVImageContainer img, AbstractOpenCVFeatureGenerator scheme) {
        return scheme.generate((AbstractImageContainer)img);
    }

    protected String toString(Object obj) {
        if (obj instanceof Row) {
            Row row = (Row)obj;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < row.getCellCount(); ++i) {
                Cell cell;
                if (i > 0) {
                    result.append(",");
                }
                if ((cell = row.getCell(i)).isNumeric()) {
                    result.append(Utils.doubleToString((double)cell.toDouble(), (int)6));
                    continue;
                }
                result.append(cell.getContent());
            }
            return result.toString();
        }
        return obj.toString();
    }

    protected boolean save(Object[] data, String filename) {
        boolean result = true;
        for (Object obj : data) {
            result = FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)this.toString(obj), (boolean)false);
            if (!result) break;
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractOpenCVFeatureGenerator[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
        }
        result = (String)result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractOpenCVFeatureGenerator[] setups = this.getRegressionSetups();
        AbstractOpenCVFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            OpenCVImageContainer data = this.load(input[i]);
            AbstractOpenCVFeatureGeneratorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            Object[] processed = this.process(data, setups[i]);
            AbstractOpenCVFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractOpenCVFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractOpenCVFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

