/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.opencv.OpenCVHelper;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public abstract class AbstractOpenCVTransformerTestCase
extends AdamsTestCase {
    public AbstractOpenCVTransformerTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/opencv/transformer/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!OpenCVHelper.isAvailable()) {
            this.m_SkipTests.add(((Object)((Object)this)).getClass().getName());
        }
    }

    protected OpenCVImageContainer load(String filename) {
        OpenCVImageContainer result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        Mat img = opencv_imgcodecs.imread((String)new TmpFile(filename).getAbsolutePath());
        if (img != null) {
            result = new OpenCVImageContainer();
            result.setImage((Object)img);
            result.getReport().setStringValue("Filename", new PlaceholderFile(filename).getName());
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected OpenCVImageContainer[] process(OpenCVImageContainer img, AbstractOpenCVTransformer scheme) {
        return (OpenCVImageContainer[])scheme.transform((AbstractImageContainer)img);
    }

    protected boolean save(OpenCVImageContainer data, String filename) {
        TmpFile file = new TmpFile(filename);
        StringBuilder content = new StringBuilder();
        content.append("Image:\n");
        content.append(Utils.flatten((Object[])Utils.breakUp((String)Utils.arrayToString((Object)BufferedImageHelper.getPixelRaster((BufferedImage)data.toBufferedImage())), (int)80), (String)"\n"));
        content.append("\n");
        content.append("Report:\n");
        Report report = data.getReport().getClone();
        report.removeValue((AbstractField)new Field("Filename", DataType.STRING));
        content.append(report);
        content.append("\n");
        content.append("Notes:\n");
        content.append(data.getNotes());
        content.append("\n");
        FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)content, (boolean)false);
        return file.exists();
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractOpenCVTransformer[] getRegressionSetups();

    protected String createOutputFilename(String input, int no, int imgNo) {
        Object result;
        String ext = "-out" + no + "_" + imgNo;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
        }
        result = (String)result + ".txt";
        return result;
    }

    public void testRegression() {
        int n;
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[][] output = new String[input.length][];
        AbstractOpenCVTransformer[] setups = this.getRegressionSetups();
        AbstractOpenCVTransformerTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            OpenCVImageContainer data = this.load(input[i]);
            AbstractOpenCVTransformerTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            OpenCVImageContainer[] processed = this.process(data, setups[i]);
            AbstractOpenCVTransformerTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = new String[processed.length];
            for (n = 0; n < output[i].length; ++n) {
                output[i][n] = this.createOutputFilename(input[i], i, n);
                boolean ok = this.save(processed[n], output[i][n]);
                AbstractOpenCVTransformerTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            }
        }
        ArrayList<TmpFile> outputFiles = new ArrayList<TmpFile>();
        for (i = 0; i < output.length; ++i) {
            for (n = 0; n < output[i].length; ++n) {
                outputFiles.add(new TmpFile(output[i][n]));
            }
        }
        String regression = this.m_Regression.compare((File[])outputFiles.toArray(new TmpFile[outputFiles.size()]));
        AbstractOpenCVTransformerTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            for (n = 0; n < output[i].length; ++n) {
                this.m_TestHelper.deleteFileFromTmp(output[i][n]);
            }
        }
    }
}

