/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.SpreadSheet;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.ImageReader;
import adams.data.io.input.OpenCVImageReader;
import adams.data.opencv.ColorConversionCode;
import adams.data.opencv.features.AbstractOpenCVFeatureGenerator;
import adams.data.opencv.features.Otsu;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import adams.data.opencv.transformer.ConvertType;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.env.Environment;
import adams.flow.AbstractOpenCVFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ImageFileReader;
import adams.flow.transformer.OpenCVFeatureGenerator;
import adams.flow.transformer.OpenCVTransformer;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class OpenCVFeatureGeneratorTest
extends AbstractOpenCVFlowTest {
    public OpenCVFeatureGeneratorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("6486290583_633d994a25_z.jpg");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("6486290583_633d994a25_z.jpg");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(OpenCVFeatureGeneratorTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/6486290583_633d994a25_z.jpg"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            filesupplier.setUseForwardSlashes(true);
            actors.add(filesupplier);
            ImageFileReader imagefilereader = new ImageFileReader();
            OpenCVImageReader opencvimagereader = new OpenCVImageReader();
            imagefilereader.setReader((ImageReader)opencvimagereader);
            DefaultSimpleReportReader defaultsimplereportreader = new DefaultSimpleReportReader();
            imagefilereader.setMetaDataReader((AbstractReportReader)defaultsimplereportreader);
            actors.add(imagefilereader);
            ConvertType convert = new ConvertType();
            convert.setConversion(ColorConversionCode.COLOR_BGR2GRAY);
            OpenCVTransformer transformer = new OpenCVTransformer();
            transformer.setTransformAlgorithm((AbstractOpenCVTransformer)convert);
            actors.add(transformer);
            OpenCVFeatureGenerator opencvfeaturegenerator = new OpenCVFeatureGenerator();
            Otsu otsu = new Otsu();
            SpreadSheet spreadsheet = new SpreadSheet();
            DenseDataRow densedatarow = new DenseDataRow();
            spreadsheet.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            spreadsheet.setSpreadSheetType((adams.data.spreadsheet.SpreadSheet)defaultspreadsheet);
            otsu.setConverter((AbstractFeatureConverter)spreadsheet);
            opencvfeaturegenerator.setAlgorithm((AbstractOpenCVFeatureGenerator)otsu);
            actors.add(opencvfeaturegenerator);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            OpenCVFeatureGeneratorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        OpenCVFeatureGeneratorTest.runTest((Test)OpenCVFeatureGeneratorTest.suite());
    }
}

