/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.ImageReader;
import adams.data.io.input.OpenCVImageReader;
import adams.data.io.output.ImageWriter;
import adams.data.io.output.OpenCVImageWriter;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import adams.data.opencv.transformer.GaussianBlur;
import adams.env.Environment;
import adams.flow.AbstractOpenCVFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.ImageFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ImageFileReader;
import adams.flow.transformer.OpenCVTransformer;
import adams.test.TmpFile;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class OpenCVTransformerTest
extends AbstractOpenCVFlowTest {
    public OpenCVTransformerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("6486290583_633d994a25_z.jpg");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("6486290583_633d994a25_z.jpg");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(OpenCVTransformerTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/6486290583_633d994a25_z.jpg"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            filesupplier.setUseForwardSlashes(true);
            actors.add(filesupplier);
            ImageFileReader imagefilereader = new ImageFileReader();
            OpenCVImageReader opencvimagereader = new OpenCVImageReader();
            imagefilereader.setReader((ImageReader)opencvimagereader);
            DefaultSimpleReportReader defaultsimplereportreader = new DefaultSimpleReportReader();
            imagefilereader.setMetaDataReader((AbstractReportReader)defaultsimplereportreader);
            actors.add(imagefilereader);
            OpenCVTransformer opencvtransformer = new OpenCVTransformer();
            GaussianBlur gaussianblur = new GaussianBlur();
            argOption = (AbstractArgumentOption)gaussianblur.getOptionManager().findByProperty("kernelWidth");
            gaussianblur.setKernelWidth(((Integer)argOption.valueOf("11")).intValue());
            argOption = (AbstractArgumentOption)gaussianblur.getOptionManager().findByProperty("kernelHeight");
            gaussianblur.setKernelHeight(((Integer)argOption.valueOf("11")).intValue());
            opencvtransformer.setTransformAlgorithm((AbstractOpenCVTransformer)gaussianblur);
            actors.add(opencvtransformer);
            ImageFileWriter writer = new ImageFileWriter();
            writer.setOutputFile((PlaceholderFile)new TmpFile("out.jpg"));
            writer.setWriter((ImageWriter)new OpenCVImageWriter());
            actors.add(writer);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            OpenCVTransformerTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        OpenCVTransformerTest.runTest((Test)OpenCVTransformerTest.suite());
    }
}

