/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.ImageWriter;
import adams.data.io.output.OpenCVImageWriter;
import adams.data.opencv.ImreadMode;
import adams.data.opencv.OpenCVImageContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public class OpenCVImageReader
extends AbstractImageReader<OpenCVImageContainer> {
    private static final long serialVersionUID = -114794988520002906L;
    protected String[] m_FormatExtensions;
    protected ImreadMode m_Mode;

    public String globalInfo() {
        return "Reads images using OpenCV.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("mode", "mode", (Object)ImreadMode.IMREAD_UNCHANGED);
    }

    protected void initialize() {
        super.initialize();
        ArrayList<String> formats = new ArrayList<String>();
        formats.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        if (!formats.contains("ppm")) {
            formats.add("ppm");
        }
        if (!formats.contains("pgm")) {
            formats.add("pgm");
        }
        Collections.sort(formats);
        this.m_FormatExtensions = formats.toArray(new String[formats.size()]);
    }

    public void setMode(ImreadMode value) {
        this.m_Mode = value;
        this.reset();
    }

    public ImreadMode getMode() {
        return this.m_Mode;
    }

    public String modeTipText() {
        return "How to read the image.";
    }

    public String getFormatDescription() {
        return "OpenCV";
    }

    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    public ImageWriter getCorrespondingWriter() {
        return new OpenCVImageWriter();
    }

    protected OpenCVImageContainer doRead(PlaceholderFile file) {
        OpenCVImageContainer result = null;
        Mat image = opencv_imgcodecs.imread((String)file.getAbsolutePath(), (int)this.m_Mode.getMode());
        if (image != null) {
            result = new OpenCVImageContainer();
            result.setImage(image);
        }
        return result;
    }
}

