/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.base.BaseInteger;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.ImageReader;
import adams.data.io.input.OpenCVImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.opencv.ImwriteFlag;
import adams.data.opencv.OpenCVImageContainer;
import gnu.trove.list.array.TIntArrayList;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public class OpenCVImageWriter
extends AbstractImageWriter<OpenCVImageContainer> {
    private static final long serialVersionUID = 7557585219819025299L;
    protected ImwriteFlag[] m_Flags;
    protected BaseInteger[] m_Values;

    public String globalInfo() {
        return "Writes images using OpenCV. Writing can be influenced via the write flags and their corresponding values.\nFor more information see:\nhttps://docs.opencv.org/4.6.0/d8/d6a/group__imgcodecs__flags.html#ga292d81be8d76901bff7988d18d2b42ac";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("flag", "flags", (Object)new ImwriteFlag[0]);
        this.m_OptionManager.add("value", "values", (Object)new BaseInteger[0]);
    }

    public void setFlags(ImwriteFlag[] value) {
        this.m_Flags = value;
        this.m_Values = (BaseInteger[])Utils.adjustArray((Object)this.m_Values, (int)this.m_Flags.length, (Object)new BaseInteger());
        this.reset();
    }

    public ImwriteFlag[] getFlags() {
        return this.m_Flags;
    }

    public String flagsTipText() {
        return "The flags influencing the writing.";
    }

    public void setValues(BaseInteger[] value) {
        this.m_Values = value;
        this.m_Flags = (ImwriteFlag[])Utils.adjustArray((Object)this.m_Flags, (int)this.m_Values.length, (Object)((Object)ImwriteFlag.IMWRITE_JPEG_QUALITY));
        this.reset();
    }

    public BaseInteger[] getValues() {
        return this.m_Values;
    }

    public String valuesTipText() {
        return "The values corresponding with the flags.";
    }

    public String getFormatDescription() {
        return new OpenCVImageReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new OpenCVImageReader().getFormatExtensions();
    }

    public ImageReader getCorrespondingReader() {
        return new OpenCVImageReader();
    }

    protected String doWrite(PlaceholderFile file, OpenCVImageContainer cont) {
        TIntArrayList flags = new TIntArrayList();
        for (int i = 0; i < this.m_Flags.length; ++i) {
            flags.add(this.m_Flags[i].getFlag());
            flags.add(this.m_Values[i].intValue());
        }
        boolean retVal = flags.size() == 0 ? opencv_imgcodecs.imwrite((String)file.getAbsolutePath(), (Mat)((Mat)cont.getContent())) : opencv_imgcodecs.imwrite((String)file.getAbsolutePath(), (Mat)((Mat)cont.getContent()), (int[])flags.toArray());
        if (retVal) {
            return null;
        }
        return "Failed to write image to (flags: " + Utils.arrayToString((Object)flags.toArray()) + "): " + file;
    }
}

