/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv;

import adams.data.Notes;
import adams.data.image.AbstractImageContainer;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.report.Report;
import java.awt.image.BufferedImage;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public class OpenCVHelper {
    protected static Boolean m_Available;

    public static synchronized boolean isAvailable() {
        if (m_Available == null) {
            try {
                new opencv_imgcodecs();
                m_Available = true;
            }
            catch (Throwable e) {
                m_Available = false;
            }
        }
        return m_Available;
    }

    public static BufferedImage toBufferedImage(Mat mat) {
        Frame frame = new OpenCVFrameConverter.ToMat().convert(mat);
        BufferedImage result = new Java2DFrameConverter().convert(frame);
        return result;
    }

    public static Mat toMat(BufferedImage image) {
        Frame frame = new Java2DFrameConverter().convert(image);
        Mat result = new OpenCVFrameConverter.ToMat().convert(frame);
        return result;
    }

    public static OpenCVImageContainer toOpenCVImageContainer(AbstractImageContainer cont) {
        if (cont instanceof OpenCVImageContainer) {
            return (OpenCVImageContainer)cont;
        }
        Report report = cont.getReport().getClone();
        Notes notes = cont.getNotes().getClone();
        OpenCVImageContainer result = new OpenCVImageContainer();
        result.setImage(OpenCVHelper.toMat(cont.toBufferedImage()));
        result.setReport(report);
        result.setNotes(notes);
        return result;
    }
}

