/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.features.AbstractOpenCVFeatureGenerator;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;

public class Histogram
extends AbstractOpenCVFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_NumBins;
    protected float m_MinValue;
    protected float m_MaxValue;
    protected boolean m_GroupChannels;

    public String globalInfo() {
        return "Computes a histogram from the incoming image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-bins", "numBins", (Object)256, (Number)1, (Number)256);
        this.m_OptionManager.add("min-value", "minValue", (Object)Float.valueOf(0.0f));
        this.m_OptionManager.add("max-value", "maxValue", (Object)Float.valueOf(255.0f));
        this.m_OptionManager.add("group-channels", "groupChannels", (Object)false);
    }

    public void setNumBins(int value) {
        if (this.getOptionManager().isValid("numBins", (Number)value)) {
            this.m_NumBins = value;
            this.reset();
        }
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to generate.";
    }

    public void setMinValue(float value) {
        if (this.getOptionManager().isValid("minValue", (Number)Float.valueOf(value))) {
            this.m_MinValue = value;
            this.reset();
        }
    }

    public float getMinValue() {
        return this.m_MinValue;
    }

    public String minValueTipText() {
        return "The min value to use.";
    }

    public void setMaxValue(float value) {
        if (this.getOptionManager().isValid("maxValue", (Number)Float.valueOf(value))) {
            this.m_MaxValue = value;
            this.reset();
        }
    }

    public float getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The max value to use.";
    }

    public void setGroupChannels(boolean value) {
        this.m_GroupChannels = value;
        this.reset();
    }

    public boolean getGroupChannels() {
        return this.m_GroupChannels;
    }

    public String groupChannelsTipText() {
        return "If enabled, grouping is by channel rather than by bin.";
    }

    public HeaderDefinition createHeader(OpenCVImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        if (this.m_GroupChannels) {
            for (int i = 0; i < this.m_NumBins; ++i) {
                for (int n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
                    result.add("channel-" + n + "-" + i, DataType.NUMERIC);
                }
            }
        } else {
            for (int n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
                for (int i = 0; i < this.m_NumBins; ++i) {
                    result.add("channel-" + n + "-" + i, DataType.NUMERIC);
                }
            }
        }
        return result;
    }

    public List<Object>[] generateRows(OpenCVImageContainer img) {
        int n;
        int i;
        List[] result = new List[]{new ArrayList()};
        MatVector channelImgs = new MatVector();
        opencv_core.split((Mat)((Mat)img.getContent()), (MatVector)channelImgs);
        int[] idxs = new int[((Mat)img.getContent()).channels()];
        for (i = 0; i < idxs.length; ++i) {
            idxs[i] = i;
        }
        IntPointer channelIdxs = new IntPointer(idxs);
        Mat[] hist = new Mat[((Mat)img.getContent()).channels()];
        for (n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
            IntPointer histSize = new IntPointer(1L);
            histSize.put(0L, this.m_NumBins);
            FloatPointer ranges = new FloatPointer(new float[]{this.m_MinValue, this.m_MaxValue});
            hist[n] = new Mat();
            opencv_imgproc.calcHist((Mat)channelImgs.get((long)n), (int)1, (IntPointer)channelIdxs, (Mat)new Mat(), (Mat)hist[n], (int)1, (IntPointer)histSize, (FloatPointer)ranges);
        }
        double[][] dest = new double[((Mat)img.getContent()).channels()][this.m_NumBins];
        for (n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
            Indexer indexer = hist[n].createIndexer();
            for (i = 0; i < this.m_NumBins; ++i) {
                dest[n][i] = indexer.getDouble(new long[]{i});
            }
        }
        if (this.m_GroupChannels) {
            for (i = 0; i < this.m_NumBins; ++i) {
                for (n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
                    result[0].add(dest[n][i]);
                }
            }
        } else {
            for (n = 0; n < ((Mat)img.getContent()).channels(); ++n) {
                for (i = 0; i < this.m_NumBins; ++i) {
                    result[0].add(dest[n][i]);
                }
            }
        }
        return result;
    }
}

