/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.features;

import adams.core.Utils;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.features.AbstractOpenCVFeatureGenerator;
import java.util.ArrayList;
import java.util.List;

public class MultiOpenCVFeatureGenerator
extends AbstractOpenCVFeatureGenerator {
    private static final long serialVersionUID = -4136037171201268286L;
    protected AbstractOpenCVFeatureGenerator[] m_SubGenerators;
    protected HeaderDefinition[] m_SubHeaders;

    public String globalInfo() {
        return "Applies multiple generators to the same image and merges the generate a feature vectors side-by-side. If one of the generators should create fewer a feature vectors, missing values are used in that case.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sub-generator", "subGenerators", (Object)new AbstractOpenCVFeatureGenerator[0]);
    }

    public void setSubGenerators(AbstractOpenCVFeatureGenerator[] value) {
        this.m_SubGenerators = value;
        this.reset();
    }

    public AbstractOpenCVFeatureGenerator[] getSubGenerators() {
        return this.m_SubGenerators;
    }

    public String subGeneratorsTipText() {
        return "The feature generators to apply to the image.";
    }

    protected String createPrefix(int index) {
        String result = this.m_Prefix;
        result = result.replace("#", "" + (index + 1));
        return result;
    }

    public HeaderDefinition createHeader(OpenCVImageContainer img) {
        int i;
        this.m_SubHeaders = new HeaderDefinition[this.m_SubGenerators.length];
        for (i = 0; i < this.m_SubHeaders.length; ++i) {
            this.m_SubHeaders[i] = this.m_SubGenerators[i].createHeader(img);
            this.m_SubHeaders[i] = this.m_SubGenerators[i].postProcessHeader(this.m_SubHeaders[i]);
        }
        if (!this.m_Prefix.isEmpty()) {
            for (i = 0; i < this.m_SubHeaders.length; ++i) {
                for (int n = 0; n < this.m_SubHeaders[i].size(); ++n) {
                    String name = this.createPrefix(i) + this.m_SubHeaders[i].getName(n);
                    this.m_SubHeaders[i].rename(n, name);
                }
            }
        }
        HeaderDefinition result = new HeaderDefinition();
        if (this.m_SubHeaders.length > 0) {
            for (i = 0; i < this.m_SubHeaders.length; ++i) {
                result.add(this.m_SubHeaders[i]);
            }
        }
        return result;
    }

    public List<Object>[] generateRows(OpenCVImageContainer img) {
        List[] result;
        int n;
        int i;
        List[][] sub = new List[this.m_SubGenerators.length][];
        for (i = 0; i < this.m_SubGenerators.length; ++i) {
            sub[i] = this.m_SubGenerators[i].postProcessRows(img, this.m_SubGenerators[i].generateRows(img));
        }
        int max = 0;
        for (i = 0; i < sub.length; ++i) {
            max = Math.max(max, sub[i].length);
        }
        for (i = 0; i < sub.length; ++i) {
            int subMax = 0;
            for (n = 0; n < sub[i].length; ++n) {
                subMax = Math.max(subMax, sub[i][n].size());
            }
            ArrayList<Object> filler = new ArrayList<Object>();
            for (n = 0; n < subMax; ++n) {
                filler.add(null);
            }
            sub[i] = (List[])Utils.adjustArray((Object)sub[i], (int)max, filler);
        }
        if (sub.length > 0) {
            result = new List[max];
            for (n = 0; n < max; ++n) {
                result[n] = new ArrayList();
                for (i = 0; i < sub.length; ++i) {
                    result[n].addAll(sub[i][n]);
                }
            }
        } else {
            result = new List[]{new ArrayList()};
        }
        return result;
    }
}

