/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.opencv.ColorConversionCode;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.ThresholdType;
import adams.data.opencv.features.AbstractOpenCVFeatureGenerator;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

public class Otsu
extends AbstractOpenCVFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_MaxValue;

    public String globalInfo() {
        return "Computes the threshold using Otsu's method";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-value", "maxValue", (Object)255, (Number)0, (Number)255);
    }

    public void setMaxValue(int value) {
        if (this.getOptionManager().isValid("maxValue", (Number)value)) {
            this.m_MaxValue = value;
            this.reset();
        }
    }

    public int getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The max value to use.";
    }

    public HeaderDefinition createHeader(OpenCVImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Otsu", DataType.NUMERIC);
        return result;
    }

    public List<Object>[] generateRows(OpenCVImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        Mat mat = ((Mat)img.getContent()).clone();
        ColorConversionCode conversion = null;
        if (mat.channels() == 3) {
            conversion = ColorConversionCode.COLOR_BGR2GRAY;
        } else if (mat.channels() == 4) {
            conversion = ColorConversionCode.COLOR_BGRA2GRAY;
        }
        if (conversion != null) {
            this.getLogger().warning("Image not in grayscale, attempting conversion: " + conversion);
            opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)conversion.getCode());
        }
        double computed = opencv_imgproc.threshold((Mat)mat, (Mat)mat, (double)0.0, (double)this.m_MaxValue, (int)ThresholdType.THRESH_OTSU.getType());
        result[0].add(computed);
        return result;
    }
}

