/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.BorderType;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Size;

public class Blur
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_KernelWidth;
    protected int m_KernelHeight;
    protected int m_AnchorX;
    protected int m_AnchorY;
    protected BorderType m_BorderType;

    public String globalInfo() {
        return "Blurs the image using the normalized box filter.\nFor more information see:\nhttps://docs.opencv.org/4.6.0/d4/d86/group__imgproc__filter.html#ga8c45db9afe636703801b0b2e440fce37";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("kernel-width", "kernelWidth", (Object)3, (Number)1, null);
        this.m_OptionManager.add("kernel-height", "kernelHeight", (Object)3, (Number)1, null);
        this.m_OptionManager.add("anchor-x", "anchorX", (Object)-1);
        this.m_OptionManager.add("anchor-y", "anchorY", (Object)-1);
        this.m_OptionManager.add("border-type", "borderType", (Object)BorderType.BORDER_DEFAULT);
    }

    public void setKernelWidth(int value) {
        if (this.getOptionManager().isValid("kernelWidth", (Number)value)) {
            this.m_KernelWidth = value;
            this.reset();
        }
    }

    public int getKernelWidth() {
        return this.m_KernelWidth;
    }

    public String kernelWidthTipText() {
        return "The width to use for the kernel (positive and odd integer).";
    }

    public void setKernelHeight(int value) {
        if (this.getOptionManager().isValid("kernelHeight", (Number)value)) {
            this.m_KernelHeight = value;
            this.reset();
        }
    }

    public int getKernelHeight() {
        return this.m_KernelHeight;
    }

    public String kernelHeightTipText() {
        return "The height to use for the kernel (positive and odd integer).";
    }

    public void setAnchorX(int value) {
        if (this.getOptionManager().isValid("anchorX", (Number)value)) {
            this.m_AnchorX = value;
            this.reset();
        }
    }

    public int getAnchorX() {
        return this.m_AnchorX;
    }

    public String anchorXTipText() {
        return "The X of the anchor use -1 for the center.";
    }

    public void setAnchorY(int value) {
        if (this.getOptionManager().isValid("anchorY", (Number)value)) {
            this.m_AnchorY = value;
            this.reset();
        }
    }

    public int getAnchorY() {
        return this.m_AnchorY;
    }

    public String anchorYTipText() {
        return "The Y of the anchor, use -1 for the center.";
    }

    public void setBorderType(BorderType value) {
        this.m_BorderType = value;
        this.reset();
    }

    public BorderType getBorderType() {
        return this.m_BorderType;
    }

    public String borderTypeTipText() {
        return "The type of border to use.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_KernelWidth, (String)"w: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_KernelHeight, (String)", h: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"anchorX", (Object)this.m_AnchorX, (String)", ax: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"anchorY", (Object)this.m_AnchorY, (String)", ay: ");
        return result;
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        Mat mat = ((Mat)img.getContent()).clone();
        opencv_imgproc.blur((Mat)mat, (Mat)mat, (Size)new Size(this.m_KernelWidth, this.m_KernelHeight), (Point)new Point(this.m_AnchorX, this.m_AnchorY), (int)this.m_BorderType.getType());
        OpenCVImageContainer[] result = new OpenCVImageContainer[]{(OpenCVImageContainer)img.getHeader()};
        result[0].setContent(mat);
        return result;
    }
}

