/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.ColorConversionCode;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

public class ConvertType
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected ColorConversionCode m_Conversion;

    public String globalInfo() {
        return "Converts the image according to the conversion code.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "conversion", (Object)ColorConversionCode.COLOR_BGR2GRAY);
    }

    public void setConversion(ColorConversionCode value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ColorConversionCode getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The color conversion to apply.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)((Object)this.m_Conversion), (String)"conversion: ");
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        Mat mat = ((Mat)img.getContent()).clone();
        opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)this.m_Conversion.getCode());
        OpenCVImageContainer[] result = new OpenCVImageContainer[]{(OpenCVImageContainer)img.getHeader()};
        result[0].setContent(mat);
        return result;
    }
}

