/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.BorderType;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;

public class GaussianBlur
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_KernelWidth;
    protected int m_KernelHeight;
    protected double m_SigmaX;
    protected double m_SigmaY;
    protected BorderType m_BorderType;

    public String globalInfo() {
        return "Applies Gaussian blur to the image.\nFor more information see:\nhttps://docs.opencv.org/4.6.0/d4/d86/group__imgproc__filter.html#gaabe8c836e97159a9193fb0b11ac52cf1";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("kernel-width", "kernelWidth", (Object)3, (Number)1, null);
        this.m_OptionManager.add("kernel-height", "kernelHeight", (Object)3, (Number)1, null);
        this.m_OptionManager.add("sigma-x", "sigmaX", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("sigma-y", "sigmaY", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("border-type", "borderType", (Object)BorderType.BORDER_DEFAULT);
    }

    public void setKernelWidth(int value) {
        if (this.getOptionManager().isValid("kernelWidth", (Number)value)) {
            this.m_KernelWidth = value;
            this.reset();
        }
    }

    public int getKernelWidth() {
        return this.m_KernelWidth;
    }

    public String kernelWidthTipText() {
        return "The width to use for the kernel (positive and odd integer).";
    }

    public void setKernelHeight(int value) {
        if (this.getOptionManager().isValid("kernelHeight", (Number)value)) {
            this.m_KernelHeight = value;
            this.reset();
        }
    }

    public int getKernelHeight() {
        return this.m_KernelHeight;
    }

    public String kernelHeightTipText() {
        return "The height to use for the kernel (positive and odd integer).";
    }

    public void setSigmaX(double value) {
        if (this.getOptionManager().isValid("sigmaX", (Number)value)) {
            this.m_SigmaX = value;
            this.reset();
        }
    }

    public double getSigmaX() {
        return this.m_SigmaX;
    }

    public String sigmaXTipText() {
        return "The standard deviation for X.";
    }

    public void setSigmaY(double value) {
        if (this.getOptionManager().isValid("sigmaY", (Number)value)) {
            this.m_SigmaY = value;
            this.reset();
        }
    }

    public double getSigmaY() {
        return this.m_SigmaY;
    }

    public String sigmaYTipText() {
        return "The standard deviation for Y.";
    }

    public void setBorderType(BorderType value) {
        this.m_BorderType = value;
        this.reset();
    }

    public BorderType getBorderType() {
        return this.m_BorderType;
    }

    public String borderTypeTipText() {
        return "The type of border to use.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_KernelWidth, (String)"w: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_KernelHeight, (String)", h: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sigmaX", (Object)this.m_SigmaX, (String)", sx: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sigmaY", (Object)this.m_SigmaY, (String)", sy: ");
        return result;
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        Mat mat = ((Mat)img.getContent()).clone();
        opencv_imgproc.GaussianBlur((Mat)mat, (Mat)mat, (Size)new Size(this.m_KernelWidth, this.m_KernelHeight), (double)this.m_SigmaX, (double)this.m_SigmaY, (int)this.m_BorderType.getType());
        OpenCVImageContainer[] result = new OpenCVImageContainer[]{(OpenCVImageContainer)img.getHeader()};
        result[0].setContent(mat);
        return result;
    }
}

