/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiTransformer
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected AbstractOpenCVTransformer[] m_Transformers;

    public String globalInfo() {
        return "Applies the specified OpenCV transformers one after the other.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformers", (Object)new AbstractOpenCVTransformer[0]);
    }

    public void setTransformers(AbstractOpenCVTransformer[] value) {
        this.m_Transformers = value;
        this.reset();
    }

    public AbstractOpenCVTransformer[] getTransformers() {
        return this.m_Transformers;
    }

    public String transformersTipText() {
        return "The transformers to apply one after the other.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"transformers", (Object)this.m_Transformers, (String)"transformers: ");
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        ArrayList<OpenCVImageContainer> result = new ArrayList<OpenCVImageContainer>();
        result.add(img);
        ArrayList<OpenCVImageContainer> input = new ArrayList<OpenCVImageContainer>();
        for (int i = 0; i < this.m_Transformers.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Transformer #" + (i + 1) + "...");
            }
            input.clear();
            input.addAll(result);
            result.clear();
            for (OpenCVImageContainer cont : input) {
                result.addAll(Arrays.asList((OpenCVImageContainer[])this.m_Transformers[i].transform(cont)));
            }
        }
        return result.toArray(new OpenCVImageContainer[result.size()]);
    }
}

