/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.InterpolationType;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;

public class Resize
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected ResizeType m_Type;
    protected int m_Width;
    protected int m_Height;
    protected double m_FactorX;
    protected double m_FactorY;
    protected InterpolationType m_Interpolation;

    public String globalInfo() {
        return "Resizes the image, either using absolute width/height or factors for x/y.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)ResizeType.FACTORS);
        this.m_OptionManager.add("width", "width", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("factor-x", "factorX", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("factor-y", "factorY", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("interpolation", "interpolation", (Object)InterpolationType.CV_INTER_LINEAR);
    }

    public void setType(ResizeType value) {
        this.m_Type = value;
        this.reset();
    }

    public ResizeType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The resize type.";
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The absolute width to use, -1 uses input width.";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The absolute height to use, -1 uses input height.";
    }

    public void setFactorX(double value) {
        if (this.getOptionManager().isValid("factorX", (Number)value)) {
            this.m_FactorX = value;
            this.reset();
        }
    }

    public double getFactorX() {
        return this.m_FactorX;
    }

    public String factorXTipText() {
        return "The factor to apply to the width.";
    }

    public void setFactorY(double value) {
        if (this.getOptionManager().isValid("factorY", (Number)value)) {
            this.m_FactorY = value;
            this.reset();
        }
    }

    public double getFactorY() {
        return this.m_FactorY;
    }

    public String factorYTipText() {
        return "The factor to apply to the height.";
    }

    public void setInterpolation(InterpolationType value) {
        this.m_Interpolation = value;
        this.reset();
    }

    public InterpolationType getInterpolation() {
        return this.m_Interpolation;
    }

    public String interpolationTipText() {
        return "The interpolation type.";
    }

    public String getQuickInfo() {
        Object result = null;
        if (this.m_Type == ResizeType.ABSOLUTE) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)"width: ");
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", height: ");
        } else if (this.m_Type == ResizeType.FACTORS) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"factorX", (Object)this.m_FactorX, (String)"x: ");
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"factorY", (Object)this.m_FactorY, (String)", y: ");
        }
        return result;
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        Mat mat = ((Mat)img.getContent()).clone();
        switch (this.m_Type) {
            case ABSOLUTE: {
                int width = this.m_Width == -1 ? mat.cols() : this.m_Width;
                int height = this.m_Height == -1 ? mat.rows() : this.m_Height;
                opencv_imgproc.resize((Mat)mat, (Mat)mat, (Size)new Size(width, height), (double)0.0, (double)0.0, (int)this.m_Interpolation.getType());
                break;
            }
            case FACTORS: {
                opencv_imgproc.resize((Mat)mat, (Mat)mat, (Size)new Size(), (double)this.m_FactorX, (double)this.m_FactorY, (int)this.m_Interpolation.getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled resize type: " + this.m_Type);
            }
        }
        OpenCVImageContainer[] result = new OpenCVImageContainer[]{(OpenCVImageContainer)img.getHeader()};
        result[0].setContent(mat);
        return result;
    }

    public static enum ResizeType {
        ABSOLUTE,
        FACTORS;

    }
}

