/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;

public class SplitChannels
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;

    public String globalInfo() {
        return "Splits the channels in the incoming image into separate containers.";
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        OpenCVImageContainer[] result = new OpenCVImageContainer[((Mat)img.getContent()).channels()];
        MatVector channels = new MatVector();
        opencv_core.split((Mat)((Mat)img.getContent()), (MatVector)channels);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (OpenCVImageContainer)img.getHeader();
            result[i].setContent(channels.get((long)i));
            result[i].getReport().setNumericValue("Channel", (double)i);
        }
        return result;
    }
}

