/*
 * Decompiled with CFR 0.152.
 */
package adams.data.opencv.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.opencv.ColorConversionCode;
import adams.data.opencv.OpenCVImageContainer;
import adams.data.opencv.ThresholdType;
import adams.data.opencv.transformer.AbstractOpenCVTransformer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

public class Threshold
extends AbstractOpenCVTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_Threshold;
    protected int m_MaxValue;
    protected ThresholdType m_Type;

    public String globalInfo() {
        return "Generates a binary image using the specified image. Automatically converts the image to grayscale.\nFor more information see:\nhttps://docs.opencv.org/4.6.0/d7/d1b/group__imgproc__misc.html#gaa9e58d2860d4afa658ef70a9b1115576";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)127, (Number)0, (Number)255);
        this.m_OptionManager.add("max-value", "maxValue", (Object)255, (Number)0, (Number)255);
        this.m_OptionManager.add("type", "type", (Object)ThresholdType.THRESH_BINARY);
    }

    public void setThreshold(int value) {
        if (this.getOptionManager().isValid("threshold", (Number)value)) {
            this.m_Threshold = value;
            this.reset();
        }
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold to apply to the gray pixel values.";
    }

    public void setMaxValue(int value) {
        if (this.getOptionManager().isValid("maxValue", (Number)value)) {
            this.m_MaxValue = value;
            this.reset();
        }
    }

    public int getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The max value to use.";
    }

    public void setType(ThresholdType value) {
        this.m_Type = value;
        this.reset();
    }

    public ThresholdType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of thresholding to apply.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"threshold", (Object)this.m_Threshold, (String)"threshold: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxValue", (Object)this.m_MaxValue, (String)", max: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    protected OpenCVImageContainer[] doTransform(OpenCVImageContainer img) {
        Mat mat = ((Mat)img.getContent()).clone();
        ColorConversionCode conversion = null;
        if (mat.channels() == 3) {
            conversion = ColorConversionCode.COLOR_BGR2GRAY;
        } else if (mat.channels() == 4) {
            conversion = ColorConversionCode.COLOR_BGRA2GRAY;
        }
        if (conversion != null) {
            this.getLogger().warning("Image not in grayscale, attempting conversion: " + conversion);
            opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)conversion.getCode());
        }
        double computed = opencv_imgproc.threshold((Mat)mat, (Mat)mat, (double)this.m_Threshold, (double)this.m_MaxValue, (int)this.m_Type.getType());
        OpenCVImageContainer[] result = new OpenCVImageContainer[]{(OpenCVImageContainer)img.getHeader()};
        result[0].setContent(mat);
        result[0].getReport().setNumericValue("Threshold", computed);
        return result;
    }
}

