/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseClassname;
import adams.core.option.OptionHandler;
import adams.data.opencv.OpenCVImageContainer;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.bytedeco.opencv.opencv_core.Mat;

public class OpenCVDeviceFrameGrabber
extends AbstractSource {
    private static final long serialVersionUID = 5117434255083739200L;
    protected BaseClassname m_FrameGrabberClass;
    protected int m_Device;
    protected long m_Delay;
    protected transient FrameGrabber m_FrameGrabber;
    protected transient OpenCVFrameConverter.ToMat m_Converter;

    public String globalInfo() {
        return "Grabs frames from the specified device and forwards them as image containers.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("frame-grabber-class", "frameGrabberClass", (Object)new BaseClassname(OpenCVFrameGrabber.class));
        this.m_OptionManager.add("device", "device", (Object)0);
        this.m_OptionManager.add("delay", "delay", (Object)0L, (Number)0L, null);
    }

    public void setFrameGrabberClass(BaseClassname value) {
        this.m_FrameGrabberClass = value;
        this.reset();
    }

    public BaseClassname getFrameGrabberClass() {
        return this.m_FrameGrabberClass;
    }

    public String frameGrabberClassTipText() {
        return "The frame grabber class to utilize for obtaining the frames.";
    }

    public void setDevice(int value) {
        this.m_Device = value;
        this.reset();
    }

    public int getDevice() {
        return this.m_Device;
    }

    public String deviceTipText() {
        return "The ID of the device to grab frames from.";
    }

    public void setDelay(long value) {
        this.m_Delay = value;
        this.reset();
    }

    public long getDelay() {
        return this.m_Delay;
    }

    public String delayTipText() {
        return "The delay in microsecond before grabbing a frame.";
    }

    public Class[] generates() {
        return new Class[]{OpenCVImageContainer.class};
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"frameGrabberClass", (Object)this.m_FrameGrabberClass, (String)"grabber: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"device", (Object)this.m_Device, (String)", device: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"delay", (Object)this.m_Delay, (String)", \u03bcsec delay: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Constructor constructor = this.m_FrameGrabberClass.classValue().getConstructor(Integer.TYPE);
            this.m_FrameGrabber = (FrameGrabber)constructor.newInstance(this.m_Device);
            this.m_Converter = new OpenCVFrameConverter.ToMat();
            this.m_FrameGrabber.start();
        }
        catch (Exception e) {
            result = this.handleException("Failed to start frame grabber for device " + this.m_Device + ":", e);
            this.closeFrameGrabber();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token output() {
        Token result = null;
        if (!this.isStopped() && this.m_FrameGrabber != null) {
            FrameGrabber frameGrabber = this.m_FrameGrabber;
            synchronized (frameGrabber) {
                try {
                    Frame frame;
                    if (this.m_Delay > 0L) {
                        this.m_FrameGrabber.delayedGrab(this.m_Delay);
                        frame = this.m_FrameGrabber.getDelayedFrame();
                    } else {
                        frame = this.m_FrameGrabber.grab();
                    }
                    if (frame != null) {
                        Mat img = this.m_Converter.convert(frame.clone());
                        OpenCVImageContainer cont = new OpenCVImageContainer();
                        cont.setContent(img);
                        result = new Token((Object)cont);
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to grab frame, closing frame grabber!", (Throwable)e);
                    this.closeFrameGrabber();
                }
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_FrameGrabber != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFrameGrabber() {
        if (this.m_FrameGrabber != null) {
            FrameGrabber frameGrabber = this.m_FrameGrabber;
            synchronized (frameGrabber) {
                try {
                    this.m_FrameGrabber.close();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Error closing frame grabber:", (Throwable)e);
                }
                this.m_FrameGrabber = null;
            }
        }
    }

    public void stopExecution() {
        super.stopExecution();
        this.closeFrameGrabber();
    }

    public void wrapUp() {
        super.wrapUp();
        this.closeFrameGrabber();
    }
}

