/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractReportMapRectangleGenerator;
import adams.data.mapobject.SimpleMapRectangle;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.awt.Color;
import java.awt.Font;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class SimpleReportRectangleGenerator
extends AbstractReportMapRectangleGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected Field m_Name;
    protected Color m_RectangleColor;
    protected Color m_FillColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Generates rectangles.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)new Field("name", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("timestamp", DataType.STRING));
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new Field[0]);
        this.m_OptionManager.add("rectangle-color", "rectangleColor", (Object)Color.BLUE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(200, 200, 200, 200));
        this.m_OptionManager.add("font", "font", (Object)new Font("helvetica", 0, 12));
    }

    public void setName(Field value) {
        this.m_Name = value;
        this.reset();
    }

    public Field getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The field containing the name (optional).";
    }

    public void setRectangleColor(Color value) {
        this.m_RectangleColor = value;
        this.reset();
    }

    public Color getRectangleColor() {
        return this.m_RectangleColor;
    }

    public String rectangleColorTipText() {
        return "The rectangle color.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the rectangle.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected MapRectangle doGenerate(Report report) {
        double latTL = this.getNumericValue(report, this.m_TopLeftLatitude);
        double lonTL = this.getNumericValue(report, this.m_TopLeftLongitude);
        double latBR = this.getNumericValue(report, this.m_BottomRightLatitude);
        double lonBR = this.getNumericValue(report, this.m_BottomRightLongitude);
        SimpleMapRectangle result = new SimpleMapRectangle(new Layer(this.m_Layer), new Coordinate(latTL, lonTL), new Coordinate(latBR, lonBR));
        if (report.hasValue((AbstractField)this.m_Name)) {
            String name = report.getStringValue((AbstractField)this.m_Name);
            result.setName(name);
        }
        result.setBackColor(this.m_FillColor);
        result.setColor(this.m_RectangleColor);
        result.setFont(this.m_Font);
        this.postProcess(report, result);
        return result;
    }
}

