/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.io.PlaceholderDirectory;
import adams.flow.sink.openstreetmapviewer.AbstractTileLoaderProvider;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OpenStreetMapCachedLoader
extends AbstractTileLoaderProvider {
    private static final long serialVersionUID = -3965568571771391365L;
    protected PlaceholderDirectory m_CacheDir;

    public String globalInfo() {
        return "Returns the default OpenStreetMap file cache tile loader.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache-dir", "cacheDir", (Object)new PlaceholderDirectory("${TMP}"));
    }

    public void setCacheDir(PlaceholderDirectory value) {
        this.m_CacheDir = value;
        this.reset();
    }

    public PlaceholderDirectory getCacheDir() {
        return this.m_CacheDir;
    }

    public String cacheDirTipText() {
        return "The cache directory to use.";
    }

    @Override
    protected TileLoader doGenerate(TileLoaderListener listener) throws Exception {
        return new OsmFileCacheTileLoader(listener, this.m_CacheDir.getAbsoluteFile());
    }
}

