/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapObjectGenerator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public abstract class AbstractMapPolygonGenerator
extends AbstractMapObjectGenerator<MapPolygon> {
    private static final long serialVersionUID = -8754565176631384914L;
    protected SpreadSheetColumnRange m_Coordinates;
    protected int[] m_CoordinatesIndices;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("coordinates", "coordinates", (Object)new SpreadSheetColumnRange());
    }

    public void setCoordinates(SpreadSheetColumnRange value) {
        this.m_Coordinates = value;
        this.reset();
    }

    public SpreadSheetColumnRange getCoordinates() {
        return this.m_Coordinates;
    }

    public String coordinatesTipText() {
        return "The range of columns containing the GPS objects for the polygons.";
    }

    @Override
    public Class generates() {
        return MapPolygon[].class;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"coordinates", (Object)this.m_Coordinates, (String)", coordinates: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_Coordinates.setData((Object)sheet);
        if (this.m_Coordinates.getIntIndices().length == 0) {
            throw new IllegalStateException("Failed to locate any coordinate columns: " + this.m_Coordinates.getRange());
        }
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_CoordinatesIndices = this.m_Coordinates.getIntIndices();
    }
}

