/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.option.AbstractOptionHandler;
import adams.data.mapobject.MetaDataSupporter;
import adams.gui.event.MapObjectHitEvent;
import adams.gui.event.MapObjectHitListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public abstract class AbstractMapObjectHitListener
extends AbstractOptionHandler
implements MapObjectHitListener {
    private static final long serialVersionUID = 4468210013390130296L;

    protected List<String> getMetaDataKeys(List<MapObject> hits) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> keys = new HashSet<String>();
        for (MapObject hit : hits) {
            if (!(hit instanceof MetaDataSupporter)) continue;
            MetaDataSupporter meta = (MetaDataSupporter)hit;
            for (String key : meta.metaDataKeys()) {
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        result.addAll(keys);
        Collections.sort(result);
        return result;
    }

    protected abstract void processHits(JMapViewer var1, List<MapObject> var2);

    @Override
    public void mapObjectsHit(MapObjectHitEvent e) {
        this.processHits(e.getViewer(), e.getHits());
    }
}

