/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.mapobject.MetaDataSupporter;
import adams.data.mapobject.TimestampSupporter;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public abstract class AbstractMapObjectGenerator<T extends MapObject>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -9173206961610198326L;
    protected String m_Layer;
    protected SpreadSheetColumnIndex m_Timestamp;
    protected int m_TimestampIndex;
    protected SpreadSheetColumnRange m_AdditionalAttributes;
    protected int[] m_AdditionalAttributesIndices;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("layer", "layer", (Object)this.getDefaultLayer());
    }

    protected void initialize() {
        super.initialize();
        this.m_Timestamp = new SpreadSheetColumnIndex();
        this.m_AdditionalAttributes = new SpreadSheetColumnRange();
    }

    protected String getDefaultLayer() {
        return "Default";
    }

    public void setLayer(String value) {
        this.m_Layer = value;
        this.reset();
    }

    public String getLayer() {
        return this.m_Layer;
    }

    public String layerTipText() {
        return "The name of the layer.";
    }

    public void setTimestamp(SpreadSheetColumnIndex value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The column to obtain the timestamp from for the map object (optional).";
    }

    public void setAdditionalAttributes(SpreadSheetColumnRange value) {
        this.m_AdditionalAttributes = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAdditionalAttributes() {
        return this.m_AdditionalAttributes;
    }

    public String additionalAttributesTipText() {
        return "The range of column to add to the map object as well.";
    }

    public abstract Class generates();

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"layer", (Object)this.m_Layer, (String)"Layer: ");
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("No spreadsheet supplied!");
        }
    }

    protected void init(SpreadSheet sheet) {
        this.m_Timestamp.setData((Object)sheet);
        this.m_TimestampIndex = this.m_Timestamp.getIntIndex();
        this.m_AdditionalAttributes.setData((Object)sheet);
        this.m_AdditionalAttributesIndices = this.m_AdditionalAttributes.getIntIndices();
    }

    protected void addTimestamp(Row row, TimestampSupporter mapobject) {
        if (!row.hasCell(this.m_TimestampIndex) || row.getCell(this.m_TimestampIndex).isMissing()) {
            return;
        }
        mapobject.setTimestamp(row.getCell(this.m_TimestampIndex).toAnyDateType());
    }

    protected void addMetaData(Row row, MetaDataSupporter mapobject) {
        for (int col : this.m_AdditionalAttributesIndices) {
            if (!row.hasCell(col) || row.getCell(col).isMissing()) continue;
            mapobject.addMetaData(row.getOwner().getColumnName(col), row.getCell(col).getNative());
        }
    }

    protected void postProcess(Row row, MapObject mapobject) {
        if (mapobject instanceof MetaDataSupporter) {
            this.addMetaData(row, (MetaDataSupporter)mapobject);
        }
        if (this.m_TimestampIndex != -1 && mapobject instanceof TimestampSupporter) {
            this.addTimestamp(row, (TimestampSupporter)mapobject);
        }
    }

    protected abstract T[] doGenerate(SpreadSheet var1);

    public T[] generate(SpreadSheet sheet) {
        this.check(sheet);
        this.init(sheet);
        MapObject[] result = this.doGenerate(sheet);
        return result;
    }

    public AbstractMapObjectGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractMapObjectGenerator shallowCopy(boolean expand) {
        return (AbstractMapObjectGenerator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }
}

