/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.base.BaseURL;
import adams.flow.sink.openstreetmapviewer.AbstractTileSourceProvider;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class CustomMapnikSource
extends AbstractTileSourceProvider {
    private static final long serialVersionUID = 2395465367677155756L;
    protected BaseURL m_URL;

    public String globalInfo() {
        return "Returns a tile source for a custom Mapnik server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL("http://tile.openstreetmap.org"));
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL of the custom Mapnik server to use.";
    }

    @Override
    protected TileSource doGenerate() throws Exception {
        return new OsmTileSource.Mapnik();
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik(String url) {
            super("Mapnik", url);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }
}

