/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapPolygonGenerator;
import adams.data.gps.AbstractGPS;
import adams.data.mapobject.SimpleMapPolygon;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public class SimplePolygonGenerator
extends AbstractMapPolygonGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected SpreadSheetColumnIndex m_Name;
    protected int m_NameIndex;
    protected Color m_BorderColor;
    protected Color m_FillColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Generates polygons.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("border-color", "borderColor", (Object)Color.BLUE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(100, 100, 100, 50));
        this.m_OptionManager.add("font", "font", (Object)new Font("helvetica", 0, 12));
    }

    public void setName(SpreadSheetColumnIndex value) {
        this.m_Name = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The index of the column containing the name (optional).";
    }

    public void setBorderColor(Color value) {
        this.m_BorderColor = value;
        this.reset();
    }

    public Color getBorderColor() {
        return this.m_BorderColor;
    }

    public String borderColorTipText() {
        return "The border color for the polygon.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the polygon.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_Name.setData((Object)sheet);
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_NameIndex = this.m_Name.getIntIndex();
    }

    protected MapPolygon[] doGenerate(SpreadSheet sheet) {
        ArrayList<SimpleMapPolygon> result = new ArrayList<SimpleMapPolygon>();
        for (Row row : sheet.rows()) {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            for (int col : this.m_CoordinatesIndices) {
                if (!row.hasCell(col) || row.getCell(col).isMissing()) continue;
                double lat = ((AbstractGPS)row.getCell(col).getObject()).getLatitude().toDecimal();
                double lon = ((AbstractGPS)row.getCell(col).getObject()).getLongitude().toDecimal();
                coords.add(new Coordinate(lat, lon));
            }
            SimpleMapPolygon mapobject = new SimpleMapPolygon(new Layer(this.m_Layer), coords);
            if (this.m_NameIndex > -1 && row.hasCell(this.m_NameIndex) && !row.getCell(this.m_NameIndex).isMissing()) {
                String name = row.getCell(this.m_NameIndex).getContent();
                mapobject.setName(name);
            }
            mapobject.setBackColor(this.m_FillColor);
            mapobject.setColor(this.m_BorderColor);
            mapobject.setFont(this.m_Font);
            this.postProcess(row, mapobject);
            result.add(mapobject);
        }
        return result.toArray(new MapPolygon[result.size()]);
    }
}

