/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapMarkerGenerator;
import adams.data.gps.AbstractGPS;
import adams.data.mapobject.SimpleMapMarkerDot;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class SimpleDotMarkerGenerator
extends AbstractMapMarkerGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected int m_Radius;
    protected SpreadSheetColumnIndex m_Name;
    protected int m_NameIndex;
    protected Color m_FillColor;
    protected Font m_Font;
    protected Color m_DotColor;

    public String globalInfo() {
        return "Generates dot markers.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("radius", "radius", (Object)5, (Number)1, null);
        this.m_OptionManager.add("name", "name", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("dot-color", "dotColor", (Object)Color.ORANGE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(100, 100, 100, 50));
        this.m_OptionManager.add("font", "font", (Object)new Font("helvetica", 0, 12));
    }

    public void setRadius(int value) {
        this.m_Radius = value;
        this.reset();
    }

    public int getRadius() {
        return this.m_Radius;
    }

    public String radiusTipText() {
        return "The radius of the dot in pixels.";
    }

    public void setName(SpreadSheetColumnIndex value) {
        this.m_Name = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The index of the column containing the name (optional).";
    }

    public void setDotColor(Color value) {
        this.m_DotColor = value;
        this.reset();
    }

    public Color getDotColor() {
        return this.m_DotColor;
    }

    public String dotColorTipText() {
        return "The dot color for the point.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the point.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_Name.setData((Object)sheet);
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_NameIndex = this.m_Name.getIntIndex();
    }

    protected MapMarker[] doGenerate(SpreadSheet sheet) {
        ArrayList<SimpleMapMarkerDot> result = new ArrayList<SimpleMapMarkerDot>();
        for (Row row : sheet.rows()) {
            if (!row.hasCell(this.m_GPSIndex) || row.getCell(this.m_GPSIndex).isMissing()) continue;
            double lat = ((AbstractGPS)row.getCell(this.m_GPSIndex).getObject()).getLatitude().toDecimal();
            double lon = ((AbstractGPS)row.getCell(this.m_GPSIndex).getObject()).getLongitude().toDecimal();
            SimpleMapMarkerDot mapobject = new SimpleMapMarkerDot(new Layer(this.m_Layer), new Coordinate(lat, lon));
            mapobject.setRadius(this.m_Radius);
            if (this.m_NameIndex > -1 && row.hasCell(this.m_NameIndex) && !row.getCell(this.m_NameIndex).isMissing()) {
                String name = row.getCell(this.m_NameIndex).getContent();
                mapobject.setName(name);
            }
            mapobject.setBackColor(this.m_FillColor);
            mapobject.setColor(this.m_DotColor);
            mapobject.setFont(this.m_Font);
            this.postProcess(row, mapobject);
            result.add(mapobject);
        }
        return result.toArray(new MapMarker[result.size()]);
    }
}

