/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapRectangleGenerator;
import adams.data.gps.AbstractGPS;
import adams.data.mapobject.SimpleMapRectangle;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class SimpleRectangleGenerator
extends AbstractMapRectangleGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected SpreadSheetColumnIndex m_Name;
    protected int m_NameIndex;
    protected Color m_RectangleColor;
    protected Color m_FillColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Generates rectangles.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("rectangle-color", "rectangleColor", (Object)Color.BLUE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(200, 200, 200, 200));
        this.m_OptionManager.add("font", "font", (Object)new Font("helvetica", 0, 12));
    }

    public void setName(SpreadSheetColumnIndex value) {
        this.m_Name = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The index of the column containing the name (optional).";
    }

    public void setRectangleColor(Color value) {
        this.m_RectangleColor = value;
        this.reset();
    }

    public Color getRectangleColor() {
        return this.m_RectangleColor;
    }

    public String rectangleColorTipText() {
        return "The rectangle color.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the rectangle.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_Name.setData((Object)sheet);
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_NameIndex = this.m_Name.getIntIndex();
    }

    protected MapRectangle[] doGenerate(SpreadSheet sheet) {
        ArrayList<SimpleMapRectangle> result = new ArrayList<SimpleMapRectangle>();
        for (Row row : sheet.rows()) {
            if (!row.hasCell(this.m_TopLeftIndex) || row.getCell(this.m_TopLeftIndex).isMissing() || !row.hasCell(this.m_BottomRightIndex) || row.getCell(this.m_BottomRightIndex).isMissing()) continue;
            Object[] gps = new AbstractGPS[]{(AbstractGPS)row.getCell(this.m_TopLeftIndex).getObject(), (AbstractGPS)row.getCell(this.m_BottomRightIndex).getObject()};
            if (gps[1].compareTo(gps[0]) > 0) {
                Utils.swap((Object[])gps);
            }
            double latTL = gps[0].getLatitude().toDecimal();
            double lonTL = gps[0].getLongitude().toDecimal();
            double latBR = gps[1].getLatitude().toDecimal();
            double lonBR = gps[1].getLongitude().toDecimal();
            SimpleMapRectangle mapobject = new SimpleMapRectangle(new Layer(this.m_Layer), new Coordinate(latTL, lonTL), new Coordinate(latBR, lonBR));
            if (this.m_NameIndex > -1 && row.hasCell(this.m_NameIndex) && !row.getCell(this.m_NameIndex).isMissing()) {
                String name = row.getCell(this.m_NameIndex).getContent();
                mapobject.setName(name);
            }
            mapobject.setBackColor(this.m_FillColor);
            mapobject.setColor(this.m_RectangleColor);
            mapobject.setFont(this.m_Font);
            this.postProcess(row, mapobject);
            result.add(mapobject);
        }
        return result.toArray(new MapRectangle[result.size()]);
    }
}

